/*
 * Decompiled with CFR 0.152.
 */
package com.pusher.client.example;

import com.pusher.client.Pusher;
import com.pusher.client.channel.ChannelEventListener;
import com.pusher.client.connection.ConnectionEventListener;
import com.pusher.client.connection.ConnectionStateChange;

public class ExampleApp
implements ConnectionEventListener,
ChannelEventListener {
    private final Pusher pusher;
    private final String channelName;
    private final String eventName;
    private final long startTime = System.currentTimeMillis();

    public static void main(String[] args) {
        new ExampleApp(args);
    }

    private ExampleApp(String[] args) {
        String apiKey = args.length > 0 ? args[0] : "de504dc5763aeef9ff52";
        this.channelName = args.length > 1 ? args[1] : "live_trades_ltcusd";
        this.eventName = args.length > 2 ? args[2] : "trade";
        this.pusher = Pusher.build().create(apiKey);
        this.pusher.connect(this);
        this.pusher.subscribe(this.channelName, this);
        try {
            Thread.sleep(Long.MAX_VALUE);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void onConnectionStateChange(ConnectionStateChange change) {
        System.out.println(String.format("[%d] ConnectionManager state changed from [%s] to [%s]", new Object[]{this.timestamp(), change.getPreviousState(), change.getCurrentState()}));
    }

    @Override
    public void onError(String message, String code, Throwable e) {
        System.out.println(String.format("[%d] An error was received with message [%s], code [%s], exception [%s]", this.timestamp(), message, code, e));
    }

    @Override
    public void onEvent(String channelName, String eventName, String data) {
        System.out.println(String.format("[%d] Received event [%s] on channel [%s], %s data:%n" + data, this.timestamp(), eventName, channelName, data.getClass().getSimpleName()));
    }

    @Override
    public void onSubscriptionSucceeded(String channelName) {
        System.out.println(String.format("[%d] Subscription to channel [%s] succeeded", this.timestamp(), channelName));
    }

    private long timestamp() {
        return System.currentTimeMillis() - this.startTime;
    }
}

