/*
 * Decompiled with CFR 0.152.
 */
package com.pusher.client;

import com.pusher.client.Authorizer;
import com.pusher.client.Client;
import com.pusher.client.PusherBuilder;
import com.pusher.client.channel.Channel;
import com.pusher.client.channel.ChannelEventListener;
import com.pusher.client.channel.DataEventListener;
import com.pusher.client.channel.PresenceChannel;
import com.pusher.client.channel.PresenceChannelEventListener;
import com.pusher.client.channel.PrivateChannel;
import com.pusher.client.channel.PrivateChannelEventListener;
import com.pusher.client.channel.impl.ChannelImpl;
import com.pusher.client.channel.impl.ChannelManager;
import com.pusher.client.channel.impl.PresenceChannelImpl;
import com.pusher.client.channel.impl.PrivateChannelImpl;
import com.pusher.client.connection.ConnectionEventListener;
import com.pusher.client.connection.ConnectionManager;
import com.pusher.client.connection.ConnectionState;
import com.pusher.client.connection.impl.InternalConnectionManager;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.concurrent.Executor;

public final class Pusher
implements Client {
    private final Executor listenerExecutor;
    private final InternalConnectionManager connectionManager;
    private final ChannelManager channelManager;
    private final Authorizer authorizer;

    Pusher(Executor listenerExecutor, ChannelManager channelManager, InternalConnectionManager connectionManager, Authorizer authorizer) {
        this.listenerExecutor = listenerExecutor;
        this.channelManager = channelManager;
        this.connectionManager = connectionManager;
        this.authorizer = authorizer;
    }

    public static PusherBuilder build() {
        return new PusherBuilder();
    }

    @Override
    public ConnectionManager getConnectionManager() {
        return this.connectionManager;
    }

    @Override
    public void connect() {
        this.connect(null);
    }

    @Override
    public void connect(ConnectionEventListener eventListener) {
        this.connect(eventListener, EnumSet.noneOf(ConnectionState.class));
    }

    @Override
    public void connect(ConnectionEventListener eventListener, Collection<ConnectionState> connectionStates) {
        if (eventListener != null) {
            if (connectionStates.isEmpty()) {
                this.connectionManager.bind(ConnectionState.ALL, eventListener);
            } else {
                for (ConnectionState state : connectionStates) {
                    this.connectionManager.bind(state, eventListener);
                }
            }
        } else if (!connectionStates.isEmpty()) {
            throw new IllegalArgumentException("Cannot bind to connectionManager states with a null connectionManager event listener");
        }
        this.connectionManager.connect();
    }

    @Override
    public void disconnect() {
        if (this.connectionManager.getState() == ConnectionState.CONNECTED) {
            this.connectionManager.disconnect();
        }
    }

    @Override
    public Channel subscribe(String channelName) {
        return this.subscribe(channelName, null);
    }

    @Override
    public Channel subscribe(String channelName, ChannelEventListener channelEventListener) {
        ChannelImpl channel = new ChannelImpl(channelName, this.listenerExecutor);
        this.channelManager.subscribeTo(channel, channelEventListener, null, Collections.emptyList());
        return channel;
    }

    @Override
    public Channel subscribe(String channelName, ChannelEventListener channelEventListener, DataEventListener dataEventListener, Iterable<String> eventNames) {
        ChannelImpl channel = new ChannelImpl(channelName, this.listenerExecutor);
        this.channelManager.subscribeTo(channel, channelEventListener, dataEventListener, eventNames);
        return channel;
    }

    @Override
    public PrivateChannel subscribePrivate(String channelName) {
        return this.subscribePrivate(channelName, null);
    }

    @Override
    public PrivateChannel subscribePrivate(String channelName, PrivateChannelEventListener channelEventListener) {
        return this.subscribePrivate(channelName, channelEventListener, null, Collections.emptyList());
    }

    @Override
    public PrivateChannel subscribePrivate(String channelName, PrivateChannelEventListener channelEventListener, DataEventListener dataEventListener, Iterable<String> eventNames) {
        if (this.authorizer == null) {
            throw new IllegalStateException("Cannot subscribe to a private or presence channel because no Authorizer has been set. Call PusherBuilder.setAuthorizer() before connecting to Pusher");
        }
        PrivateChannelImpl channel = new PrivateChannelImpl(this.connectionManager, channelName, this.authorizer, this.listenerExecutor);
        this.channelManager.subscribeTo(channel, channelEventListener, dataEventListener, eventNames);
        return channel;
    }

    @Override
    public PresenceChannel subscribePresence(String channelName) {
        return this.subscribePresence(channelName, null);
    }

    @Override
    public PresenceChannel subscribePresence(String channelName, PresenceChannelEventListener channelEventListener) {
        return this.subscribePresence(channelName, channelEventListener, null, Collections.emptyList());
    }

    @Override
    public PresenceChannel subscribePresence(String channelName, PresenceChannelEventListener channelEventListener, DataEventListener dataEventListener, Iterable<String> eventNames) {
        if (this.authorizer == null) {
            throw new IllegalStateException("Cannot subscribe to a private or presence channel because no Authorizer has been set. Call PusherBuilder.setAuthorizer() before connecting to Pusher");
        }
        PresenceChannelImpl channel = new PresenceChannelImpl(this.connectionManager, channelName, this.authorizer, this.listenerExecutor);
        this.channelManager.subscribeTo(channel, channelEventListener, dataEventListener, eventNames);
        return channel;
    }

    @Override
    public void unsubscribe(String channelName) {
        this.channelManager.unsubscribeFrom(channelName);
    }

    @Override
    public Channel getChannel(String channelName) {
        return this.channelManager.getChannel(channelName);
    }

    @Override
    public PrivateChannel getPrivateChannel(String channelName) {
        return this.channelManager.getPrivateChannel(channelName);
    }

    @Override
    public PresenceChannel getPresenceChannel(String channelName) {
        return this.channelManager.getPresenceChannel(channelName);
    }
}

