package com.pusher.client.example;

import com.pusher.client.Pusher;
import com.pusher.client.PusherBuilder;
import com.pusher.client.channel.ChannelEventListener;
import com.pusher.client.connection.ConnectionEventListener;
import com.pusher.client.connection.ConnectionStateChange;

public class ExampleApp implements ConnectionEventListener, ChannelEventListener {

  private final Pusher pusher;
  private final String channelName;
  private final String eventName;
  private final long startTime = System.currentTimeMillis();

  public static void main(final String[] args) {
    new ExampleApp(args);
  }

  private ExampleApp(final String[] args) {
    final var apiKey = args.length > 0 ? args[0] : "de504dc5763aeef9ff52";
    channelName = args.length > 1 ? args[1] : "live_trades_ltcusd";
    eventName = args.length > 2 ? args[2] : "trade";
    pusher = Pusher.build().create(apiKey);
    pusher.connect(this);
    pusher.subscribe(channelName, this);
    // Keep main thread asleep while we watch for events or application will terminate
    try {
      Thread.sleep(Long.MAX_VALUE);
    } catch (final InterruptedException e) {
      e.printStackTrace();
    }
  }

  /* ConnectionEventListener implementation */

  @Override
  public void onConnectionStateChange(final ConnectionStateChange change) {
    System.out.println(String.format("[%d] ConnectionManager state changed from [%s] to [%s]", timestamp(),
        change.getPreviousState(), change.getCurrentState()));
  }

  @Override
  public void onError(final String message, final String code, final Throwable e) {
    System.out.println(String.format("[%d] An error was received with message [%s], code [%s], exception [%s]",
        timestamp(), message, code, e));
  }

  /* ChannelEventListener implementation */

  @Override
  public void onEvent(final String channelName, final String eventName, final String data) {
    System.out.println(String.format("[%d] Received event [%s] on channel [%s], %s data:%n" + data, timestamp(), eventName, channelName, data.getClass().getSimpleName()));
  }

  @Override
  public void onSubscriptionSucceeded(final String channelName) {
    System.out.println(String.format("[%d] Subscription to channel [%s] succeeded", timestamp(), channelName));
  }

  private long timestamp() {
    return System.currentTimeMillis() - startTime;
  }
}
