/*
 * Decompiled with CFR 0.152.
 */
package com.pusher.client.util;

import com.pusher.client.AuthorizationFailureException;
import com.pusher.client.Authorizer;
import com.pusher.client.util.ConnectionFactory;
import com.pusher.client.util.UrlEncodedConnectionFactory;
import java.io.IOException;
import java.net.URI;
import java.util.Collections;
import java.util.Map;
import jdk.incubator.http.HttpClient;
import jdk.incubator.http.HttpRequest;
import jdk.incubator.http.HttpResponse;

public final class HttpAuthorizer
implements Authorizer {
    private final HttpClient httpClient;
    private final URI endPoint;
    private Map<String, String> mHeaders;
    private ConnectionFactory mConnectionFactory;

    public HttpAuthorizer(String endPoint) {
        this(null, endPoint, new UrlEncodedConnectionFactory());
        this.mHeaders = Collections.emptyMap();
    }

    public HttpAuthorizer(HttpClient httpClient, String endPoint) {
        this(httpClient, endPoint, new UrlEncodedConnectionFactory());
    }

    public HttpAuthorizer(HttpClient httpClient, String endPoint, ConnectionFactory connectionFactory) {
        this.httpClient = httpClient;
        this.endPoint = URI.create(endPoint);
        this.mConnectionFactory = connectionFactory;
    }

    public void setHeaders(Map<String, String> headers) {
        this.mHeaders = headers == null ? Collections.emptyMap() : headers;
    }

    Boolean isSSL() {
        return this.endPoint.getScheme().equals("https");
    }

    @Override
    public String authorize(String channelName, String socketId) throws AuthorizationFailureException {
        this.mConnectionFactory.setChannelName(channelName);
        this.mConnectionFactory.setSocketId(socketId);
        HttpRequest.Builder postRequest = HttpRequest.newBuilder((URI)this.endPoint);
        this.mHeaders.forEach((arg_0, arg_1) -> ((HttpRequest.Builder)postRequest).header(arg_0, arg_1));
        postRequest.headers(new String[]{"Content-Type", this.mConnectionFactory.getContentType(), "charset", this.mConnectionFactory.getCharset()});
        try {
            HttpResponse response = (this.httpClient == null ? HttpClient.newHttpClient() : this.httpClient).send(postRequest.POST(HttpRequest.BodyPublisher.fromString((String)this.mConnectionFactory.getBody())).build(), HttpResponse.BodyHandler.asString());
            int responseHttpStatus = response.statusCode();
            if (responseHttpStatus == 200 || responseHttpStatus == 201) {
                return (String)response.body();
            }
            throw new AuthorizationFailureException(response.toString());
        }
        catch (InterruptedException e) {
            Thread.interrupted();
            throw new RuntimeException(e);
        }
        catch (IOException e) {
            throw new AuthorizationFailureException(e);
        }
    }
}

