/*
 * Decompiled with CFR 0.152.
 */
package com.pusher.client.channel.impl;

import com.pusher.client.AuthorizationFailureException;
import com.pusher.client.Authorizer;
import com.pusher.client.channel.ChannelState;
import com.pusher.client.channel.PrivateChannel;
import com.pusher.client.channel.PrivateChannelEventListener;
import com.pusher.client.channel.SubscriptionEventListener;
import com.pusher.client.channel.impl.ChannelImpl;
import com.pusher.client.connection.ConnectionState;
import com.pusher.client.connection.impl.InternalConnectionManager;
import java.util.concurrent.Executor;

public class PrivateChannelImpl
extends ChannelImpl
implements PrivateChannel {
    private static final String CLIENT_EVENT_PREFIX = "client-";
    private final InternalConnectionManager connection;
    private final Authorizer authorizer;

    public PrivateChannelImpl(InternalConnectionManager connection, String channelName, Authorizer authorizer, Executor listenerExecutor) {
        super(channelName, listenerExecutor);
        this.connection = connection;
        this.authorizer = authorizer;
    }

    @Override
    public void trigger(String eventName, String data) {
        if (eventName == null || !eventName.startsWith(CLIENT_EVENT_PREFIX)) {
            throw new IllegalArgumentException("Cannot trigger event " + eventName + ": client events must start with \"client-\"");
        }
        if (this.state != ChannelState.SUBSCRIBED) {
            throw new IllegalStateException("Cannot trigger event " + eventName + " because channel " + this.channelName + " is in " + this.state.toString() + " state");
        }
        if (this.connection.getState() != ConnectionState.CONNECTED) {
            throw new IllegalStateException("Cannot trigger event " + eventName + " because connection is in " + this.connection.getState().toString() + " state");
        }
        this.connection.sendMessage("{\"data\":\"" + data.replace("\"", "\\\"") + "\",\"event\":\"" + eventName + "\",\"channel\":\"" + this.channelName + "\"}");
    }

    @Override
    public void bind(String eventName, SubscriptionEventListener listener) {
        if (!(listener instanceof PrivateChannelEventListener)) {
            throw new IllegalArgumentException("Only instances of PrivateChannelEventListener can be bound to a private channel");
        }
        super.bind(eventName, listener);
    }

    @Override
    public String toSubscribeMessage() {
        String authResponse = this.getAuthResponse();
        try {
            return "{\"event\":\"pusher:subscribe\",\"data\":{\"channel\":\"" + this.channelName + "\"," + authResponse.substring(1) + "}";
        }
        catch (Exception e) {
            throw new AuthorizationFailureException("Unable to parse response from Authorizer: " + authResponse, e);
        }
    }

    @Override
    protected String[] getDisallowedNameExpressions() {
        return new String[]{"^(?!private-).*"};
    }

    String getAuthResponse() {
        return this.authorizer.authorize(this.getChannelName(), this.connection.getSocketId());
    }

    @Override
    public String toString() {
        return String.format("[Private Channel: channelName=%s]", this.channelName);
    }
}

