/*
 * Decompiled with CFR 0.152.
 */
package com.pusher.client;

import com.pusher.client.Authorizer;
import com.pusher.client.Client;
import com.pusher.client.PusherBuilder;
import com.pusher.client.channel.Channel;
import com.pusher.client.channel.ChannelEventListener;
import com.pusher.client.channel.PresenceChannel;
import com.pusher.client.channel.PresenceChannelEventListener;
import com.pusher.client.channel.PrivateChannel;
import com.pusher.client.channel.PrivateChannelEventListener;
import com.pusher.client.channel.impl.ChannelImpl;
import com.pusher.client.channel.impl.ChannelManager;
import com.pusher.client.channel.impl.PresenceChannelImpl;
import com.pusher.client.channel.impl.PrivateChannelImpl;
import com.pusher.client.connection.ConnectionEventListener;
import com.pusher.client.connection.ConnectionManager;
import com.pusher.client.connection.ConnectionState;
import com.pusher.client.connection.impl.InternalConnectionManager;
import java.util.concurrent.Executor;

public final class Pusher
implements Client {
    private final Executor listenerExecutor;
    private final InternalConnectionManager connectionManager;
    private final ChannelManager channelManager;
    private final Authorizer authorizer;

    Pusher(Executor listenerExecutor, ChannelManager channelManager, InternalConnectionManager connectionManager, Authorizer authorizer) {
        this.listenerExecutor = listenerExecutor;
        this.channelManager = channelManager;
        this.connectionManager = connectionManager;
        this.authorizer = authorizer;
    }

    public static PusherBuilder build() {
        return new PusherBuilder();
    }

    @Override
    public ConnectionManager getConnectionManager() {
        return this.connectionManager;
    }

    @Override
    public void connect() {
        this.connect(null, new ConnectionState[0]);
    }

    @Override
    public void connect(ConnectionEventListener eventListener, ConnectionState ... connectionStates) {
        if (eventListener != null) {
            if (connectionStates.length == 0) {
                this.connectionManager.bind(ConnectionState.ALL, eventListener);
            } else {
                for (ConnectionState state : connectionStates) {
                    this.connectionManager.bind(state, eventListener);
                }
            }
        } else if (connectionStates.length > 0) {
            throw new IllegalArgumentException("Cannot bind to connectionManager states with a null connectionManager event listener");
        }
        this.connectionManager.connect();
    }

    @Override
    public void disconnect() {
        if (this.connectionManager.getState() == ConnectionState.CONNECTED) {
            this.connectionManager.disconnect();
        }
    }

    @Override
    public Channel subscribe(String channelName) {
        return this.subscribe(channelName, null, new String[0]);
    }

    @Override
    public Channel subscribe(String channelName, ChannelEventListener listener, String ... eventNames) {
        ChannelImpl channel = new ChannelImpl(channelName, this.listenerExecutor);
        this.channelManager.subscribeTo(channel, listener, eventNames);
        return channel;
    }

    @Override
    public PrivateChannel subscribePrivate(String channelName) {
        return this.subscribePrivate(channelName, null, new String[0]);
    }

    @Override
    public PrivateChannel subscribePrivate(String channelName, PrivateChannelEventListener listener, String ... eventNames) {
        if (this.authorizer == null) {
            throw new IllegalStateException("Cannot subscribe to a private or presence channel because no Authorizer has been set. Call PusherBuilder.setAuthorizer() before connecting to Pusher");
        }
        PrivateChannelImpl channel = new PrivateChannelImpl(this.connectionManager, channelName, this.authorizer, this.listenerExecutor);
        this.channelManager.subscribeTo(channel, listener, eventNames);
        return channel;
    }

    @Override
    public PresenceChannel subscribePresence(String channelName) {
        return this.subscribePresence(channelName, null, new String[0]);
    }

    @Override
    public PresenceChannel subscribePresence(String channelName, PresenceChannelEventListener listener, String ... eventNames) {
        if (this.authorizer == null) {
            throw new IllegalStateException("Cannot subscribe to a private or presence channel because no Authorizer has been set. Call PusherBuilder.setAuthorizer() before connecting to Pusher");
        }
        PresenceChannelImpl channel = new PresenceChannelImpl(this.connectionManager, channelName, this.authorizer, this.listenerExecutor);
        this.channelManager.subscribeTo(channel, listener, eventNames);
        return channel;
    }

    @Override
    public void unsubscribe(String channelName) {
        this.channelManager.unsubscribeFrom(channelName);
    }

    @Override
    public Channel getChannel(String channelName) {
        return this.channelManager.getChannel(channelName);
    }

    @Override
    public PrivateChannel getPrivateChannel(String channelName) {
        return this.channelManager.getPrivateChannel(channelName);
    }

    @Override
    public PresenceChannel getPresenceChannel(String channelName) {
        return this.channelManager.getPresenceChannel(channelName);
    }
}

