/*
 * Decompiled with CFR 0.152.
 */
package com.pusher.client.channel.impl;

import com.pusher.client.AuthorizationFailureException;
import com.pusher.client.channel.Channel;
import com.pusher.client.channel.ChannelEventListener;
import com.pusher.client.channel.ChannelState;
import com.pusher.client.channel.PresenceChannel;
import com.pusher.client.channel.PrivateChannel;
import com.pusher.client.channel.PrivateChannelEventListener;
import com.pusher.client.channel.impl.InternalChannel;
import com.pusher.client.connection.ConnectionEventListener;
import com.pusher.client.connection.ConnectionState;
import com.pusher.client.connection.ConnectionStateChange;
import com.pusher.client.connection.impl.InternalConnection;
import com.pusher.client.util.Factory;
import com.pusher.client.util.PusherJsonParser;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class ChannelManager
implements ConnectionEventListener {
    private final Map<String, InternalChannel> channelNameToChannelMap = new ConcurrentHashMap<String, InternalChannel>();
    private final Factory factory;
    private InternalConnection connection;

    public ChannelManager(Factory factory) {
        this.factory = factory;
    }

    public Channel getChannel(String channelName) {
        if (channelName.startsWith("private-")) {
            throw new IllegalArgumentException("Please use the getPrivateChannel method");
        }
        if (channelName.startsWith("presence-")) {
            throw new IllegalArgumentException("Please use the getPresenceChannel method");
        }
        return this.findChannelInChannelMap(channelName);
    }

    public PrivateChannel getPrivateChannel(String channelName) throws IllegalArgumentException {
        if (!channelName.startsWith("private-")) {
            throw new IllegalArgumentException("Private channels must begin with 'private-'");
        }
        return (PrivateChannel)((Object)this.findChannelInChannelMap(channelName));
    }

    public PresenceChannel getPresenceChannel(String channelName) throws IllegalArgumentException {
        if (!channelName.startsWith("presence-")) {
            throw new IllegalArgumentException("Presence channels must begin with 'presence-'");
        }
        return (PresenceChannel)((Object)this.findChannelInChannelMap(channelName));
    }

    private InternalChannel findChannelInChannelMap(String channelName) {
        return this.channelNameToChannelMap.get(channelName);
    }

    public void setConnection(InternalConnection connection) {
        if (connection == null) {
            throw new IllegalArgumentException("Cannot construct ChannelManager with a null connection");
        }
        if (this.connection != null) {
            this.connection.unbind(ConnectionState.CONNECTED, this);
        }
        this.connection = connection;
        connection.bind(ConnectionState.CONNECTED, this);
    }

    public void subscribeTo(InternalChannel channel, ChannelEventListener listener, String ... eventNames) {
        this.validateArgumentsAndBindEvents(channel, listener, eventNames);
        this.channelNameToChannelMap.put(channel.getChannelName(), channel);
        this.sendOrQueueSubscribeMessage(channel);
    }

    public void unsubscribeFrom(String channelName) {
        if (channelName == null) {
            throw new IllegalArgumentException("Cannot unsubscribe from null channel");
        }
        InternalChannel channel = this.channelNameToChannelMap.remove(channelName);
        if (channel != null && this.connection.getState() == ConnectionState.CONNECTED) {
            this.sendUnsubscribeMessage(channel);
        }
    }

    public void onMessage(String event, String rawJson) {
        InternalChannel channel;
        String channelName = PusherJsonParser.getJsonValue(rawJson, "\"channel\":");
        if (channelName != null && (channel = this.channelNameToChannelMap.get(channelName)) != null) {
            channel.onMessage(event, rawJson);
        }
    }

    @Override
    public void onConnectionStateChange(ConnectionStateChange change) {
        if (change.getCurrentState() == ConnectionState.CONNECTED) {
            for (InternalChannel channel : this.channelNameToChannelMap.values()) {
                this.sendOrQueueSubscribeMessage(channel);
            }
        }
    }

    @Override
    public void onError(String message, String code, Throwable e) {
    }

    private void sendOrQueueSubscribeMessage(InternalChannel channel) {
        this.factory.queueOnEventThread(() -> {
            if (this.connection.getState() == ConnectionState.CONNECTED) {
                try {
                    this.connection.sendMessage(channel.toSubscribeMessage());
                    channel.updateState(ChannelState.SUBSCRIBE_SENT);
                }
                catch (AuthorizationFailureException e) {
                    this.clearDownSubscription(channel, e);
                }
            }
        });
    }

    private void sendUnsubscribeMessage(InternalChannel channel) {
        this.factory.queueOnEventThread(() -> {
            this.connection.sendMessage(channel.toUnsubscribeMessage());
            channel.updateState(ChannelState.UNSUBSCRIBED);
        });
    }

    private void clearDownSubscription(InternalChannel channel, Exception e) {
        this.channelNameToChannelMap.remove(channel.getChannelName());
        channel.updateState(ChannelState.FAILED);
        if (channel.getEventListener() != null) {
            this.factory.queueOnEventThread(() -> ((PrivateChannelEventListener)channel.getEventListener()).onAuthenticationFailure(e.getMessage(), e));
        }
    }

    private void validateArgumentsAndBindEvents(InternalChannel channel, ChannelEventListener listener, String ... eventNames) {
        if (channel == null) {
            throw new IllegalArgumentException("Cannot subscribe to a null channel");
        }
        if (this.channelNameToChannelMap.containsKey(channel.getChannelName())) {
            throw new IllegalArgumentException("Already subscribed to a channel with channelName " + channel.getChannelName());
        }
        for (String eventName : eventNames) {
            channel.bind(eventName, listener);
        }
        channel.setEventListener(listener);
    }
}

