package com.pusher.client.util;

public final class PusherJsonParser {

  private PusherJsonParser() {
  }

  public static String getEscapedJsonValue(final String json, final String field) {
    final var fieldIndex = json.indexOf(field);
    if (fieldIndex < 0) {
      return null;
    }
    for (var index = fieldIndex + field.length(); ; ) {
      final var ch = json.charAt(index++);
      switch (ch) {
        case ':':
        case ' ':
          continue;
        case '\\':
          ++index;
          return json.substring(index, json.indexOf("\\\"", index));
        case '{':
          for (int openCount = 1, begin = index - 1; ; ) {
            final var ch2 = json.charAt(index++);
            if (ch2 == '{') {
              openCount++;
              continue;
            }
            if (ch2 == '}' && --openCount == 0) {
              return json.substring(begin, index);
            }
          }
        default:
          if (Character.isSpaceChar(ch)) {
            continue;
          }
          for (final var begin = index - 1; ; index++) {
            final var ch2 = json.charAt(index);
            if (ch2 == ',' || Character.isSpaceChar(ch2)) {
              return json.substring(begin, index);
            }
          }
      }
    }
  }

  public static String getJsonValue(final String json, final String field) {
    final var fieldIndex = json.indexOf(field);
    if (fieldIndex < 0) {
      return null;
    }
    for (var index = fieldIndex + field.length(); ; ) {
      final var ch = json.charAt(index++);
      switch (ch) {
        case ':':
        case ' ':
          continue;
        case '"':
          return json.substring(index, json.indexOf('"', index));
        case '{':
          for (int openCount = 1, begin = index - 1; ; ) {
            final var ch2 = json.charAt(index++);
            if (ch2 == '{') {
              openCount++;
              continue;
            }
            if (ch2 == '}' && --openCount == 0) {
              return json.substring(begin, index);
            }
          }
        default:
          if (Character.isSpaceChar(ch)) {
            continue;
          }
          for (final var begin = index - 1; ; index++) {
            final var ch2 = json.charAt(index);
            if (ch2 == ',' || Character.isSpaceChar(ch2)) {
              return json.substring(begin, index);
            }
          }
      }
    }
  }
}
