/*
 * Decompiled with CFR 0.152.
 */
package com.pusher.client.channel.impl;

import com.pusher.client.AuthorizationFailureException;
import com.pusher.client.Authorizer;
import com.pusher.client.channel.ChannelEventListener;
import com.pusher.client.channel.PresenceChannel;
import com.pusher.client.channel.PresenceChannelEventListener;
import com.pusher.client.channel.SubscriptionEventListener;
import com.pusher.client.channel.User;
import com.pusher.client.channel.impl.PrivateChannelImpl;
import com.pusher.client.connection.impl.InternalConnection;
import com.pusher.client.util.Factory;
import com.pusher.client.util.PusherJsonParser;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

public class PresenceChannelImpl
extends PrivateChannelImpl
implements PresenceChannel {
    private static final String MEMBER_ADDED_EVENT = "pusher_internal:member_added";
    private static final String MEMBER_REMOVED_EVENT = "pusher_internal:member_removed";
    private final Map<String, User> idToUserMap = new ConcurrentHashMap<String, User>();
    private String myUserID;

    public PresenceChannelImpl(InternalConnection connection, String channelName, Authorizer authorizer, Factory factory) {
        super(connection, channelName, authorizer, factory);
    }

    @Override
    public Set<User> getUsers() {
        return Set.copyOf(this.idToUserMap.values());
    }

    @Override
    public User getMe() {
        return this.idToUserMap.get(this.myUserID);
    }

    @Override
    public void onMessage(String event, String rawJson) {
        super.onMessage(event, rawJson);
        switch (event) {
            case "pusher_internal:subscription_succeeded": {
                this.handleSubscriptionSuccessfulMessage(rawJson);
                break;
            }
            case "pusher_internal:member_added": {
                this.handleMemberAddedEvent(rawJson);
                break;
            }
            case "pusher_internal:member_removed": {
                this.handleMemberRemovedEvent(rawJson);
            }
        }
    }

    @Override
    public String toSubscribeMessage() {
        String authResponse = this.getAuthResponse();
        try {
            this.myUserID = PusherJsonParser.getEscapedJsonValue(authResponse, "\\\"user_id\\\":");
            return "{\"event\":\"pusher:subscribe\",\"data\":{\"channel\":\"" + this.channelName + "\"," + authResponse.substring(1) + "}";
        }
        catch (Exception e) {
            throw new AuthorizationFailureException("Unable to parse response from Authorizer: " + authResponse, e);
        }
    }

    @Override
    public void bind(String eventName, SubscriptionEventListener listener) {
        if (!(listener instanceof PresenceChannelEventListener)) {
            throw new IllegalArgumentException("Only instances of PresenceChannelEventListener can be bound to a presence channel");
        }
        super.bind(eventName, listener);
    }

    @Override
    protected String[] getDisallowedNameExpressions() {
        return new String[]{"^(?!presence-).*"};
    }

    @Override
    public String toString() {
        return String.format("[Presence Channel: channelName=%s]", this.channelName);
    }

    private void handleSubscriptionSuccessfulMessage(String rawJson) {
        this.parseUsers(rawJson);
        ChannelEventListener listener = this.getEventListener();
        if (listener != null) {
            PresenceChannelEventListener presenceListener = (PresenceChannelEventListener)listener;
            presenceListener.onUsersInformationReceived(this.getChannelName(), this.getUsers());
        }
    }

    private void parseUsers(String json) {
        int hashIndex = json.indexOf("\\\"hash\\\":");
        if (hashIndex < 0) {
            return;
        }
        int index = json.indexOf("{", hashIndex + 9);
        while (true) {
            char ch;
            int beginKey = json.indexOf("\\\"", index) + 2;
            int endKey = json.indexOf("\\\"", beginKey);
            String key = json.substring(beginKey, endKey);
            int beginUserData = json.indexOf("{", endKey + 2);
            index = beginUserData + 1;
            int openCount = 1;
            while (true) {
                char ch2;
                if ((ch2 = json.charAt(index++)) == '{') {
                    ++openCount;
                    continue;
                }
                if (ch2 == '}' && --openCount == 0) break;
            }
            String userData = json.substring(beginUserData, index).replace("\\\"", "\"");
            this.idToUserMap.put(key, new User(key, userData));
            do {
                if ((ch = json.charAt(index++)) != '}') continue;
                return;
            } while (ch != ',');
        }
    }

    private void handleMemberAddedEvent(String rawJson) {
        String userId = PusherJsonParser.getEscapedJsonValue(rawJson, "\\\"user_id\\\":");
        String userInfo = PusherJsonParser.getEscapedJsonValue(rawJson, "\\\"user_info\\\":");
        User user = new User(userId, userInfo == null ? null : userInfo.replace("\\\"", "\""));
        this.idToUserMap.put(userId, user);
        ChannelEventListener listener = this.getEventListener();
        if (listener != null) {
            PresenceChannelEventListener presenceListener = (PresenceChannelEventListener)listener;
            presenceListener.userSubscribed(this.getChannelName(), user);
        }
    }

    private void handleMemberRemovedEvent(String rawJson) {
        String userId = PusherJsonParser.getEscapedJsonValue(rawJson, "\\\"user_id\\\":");
        User user = this.idToUserMap.remove(userId);
        ChannelEventListener listener = this.getEventListener();
        if (listener != null) {
            PresenceChannelEventListener presenceListener = (PresenceChannelEventListener)listener;
            presenceListener.userUnsubscribed(this.getChannelName(), user);
        }
    }
}

