/*
 * Decompiled with CFR 0.152.
 */
package com.pusher.client.channel.impl;

import com.pusher.client.channel.ChannelEventListener;
import com.pusher.client.channel.ChannelState;
import com.pusher.client.channel.SubscriptionEventListener;
import com.pusher.client.channel.impl.InternalChannel;
import com.pusher.client.util.Factory;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

public class ChannelImpl
implements InternalChannel {
    private static final String INTERNAL_EVENT_PREFIX = "pusher_internal:";
    static final String SUBSCRIPTION_SUCCESS_EVENT = "pusher_internal:subscription_succeeded";
    protected final String channelName;
    private final Map<String, Set<SubscriptionEventListener>> eventNameToListenerMap = new ConcurrentHashMap<String, Set<SubscriptionEventListener>>();
    protected volatile ChannelState state = ChannelState.INITIAL;
    private ChannelEventListener eventListener;
    private final Factory factory;

    public ChannelImpl(String channelName, Factory factory) {
        if (channelName == null) {
            throw new IllegalArgumentException("Cannot subscribe to a channel with a null channelName");
        }
        for (String disallowedPattern : this.getDisallowedNameExpressions()) {
            if (!channelName.matches(disallowedPattern)) continue;
            throw new IllegalArgumentException("Channel channelName " + channelName + " is invalid. Private channel names must start with \"private-\" and presence channel names must start with \"presence-\"");
        }
        this.channelName = channelName;
        this.factory = factory;
    }

    @Override
    public String getChannelName() {
        return this.channelName;
    }

    @Override
    public void bind(String eventName, SubscriptionEventListener listener) {
        this.validateArguments(eventName, listener);
        this.eventNameToListenerMap.computeIfAbsent(eventName, _eventName -> Collections.newSetFromMap(new ConcurrentHashMap())).add(listener);
    }

    @Override
    public void unbind(String eventName, SubscriptionEventListener listener) {
        this.validateArguments(eventName, listener);
        this.eventNameToListenerMap.getOrDefault(eventName, Collections.emptySet()).remove(listener);
    }

    @Override
    public boolean isSubscribed() {
        return this.state == ChannelState.SUBSCRIBED;
    }

    @Override
    public void onMessage(String event, String rawJson) {
        if (event.equals(SUBSCRIPTION_SUCCESS_EVENT)) {
            this.updateState(ChannelState.SUBSCRIBED);
            return;
        }
        String data = ChannelImpl.getData(rawJson);
        for (SubscriptionEventListener listener : this.eventNameToListenerMap.getOrDefault(event, Collections.emptySet())) {
            this.factory.queueOnEventThread(() -> listener.onEvent(this.channelName, event, data));
        }
    }

    private static String getData(String json) {
        char ch;
        int index = json.indexOf("\"data\":");
        if (index < 0) {
            return null;
        }
        index += 7;
        while ((ch = json.charAt(index++)) != '\"') {
        }
        int begin = index;
        char prevCh = json.charAt(index);
        char ch2 = json.charAt(++index);
        while (ch2 != '\"' || prevCh == '\\') {
            prevCh = ch2;
            ch2 = json.charAt(++index);
        }
        return json.substring(begin, index).replace("\\\"", "\"");
    }

    @Override
    public String toSubscribeMessage() {
        return "{\"event\":\"pusher:subscribe\",\"data\":{\"channel\":\"" + this.channelName + "\"}}";
    }

    @Override
    public String toUnsubscribeMessage() {
        return "{\"event\":\"pusher:unsubscribe\",\"data\":{\"channel\":\"" + this.channelName + "\"}}";
    }

    @Override
    public void updateState(ChannelState state) {
        this.state = state;
        if (state == ChannelState.SUBSCRIBED && this.eventListener != null) {
            this.factory.queueOnEventThread(() -> this.eventListener.onSubscriptionSucceeded(this.channelName));
        }
    }

    @Override
    public void setEventListener(ChannelEventListener listener) {
        this.eventListener = listener;
    }

    @Override
    public ChannelEventListener getEventListener() {
        return this.eventListener;
    }

    @Override
    public int compareTo(InternalChannel other) {
        return this.channelName.compareTo(other.getChannelName());
    }

    public String toString() {
        return String.format("[Public Channel: channelName=%s]", this.channelName);
    }

    protected String[] getDisallowedNameExpressions() {
        return new String[]{"^private-.*", "^presence-.*"};
    }

    private void validateArguments(String eventName, SubscriptionEventListener listener) {
        if (eventName == null) {
            throw new IllegalArgumentException("Cannot bind or unbind to channel " + this.channelName + " with a null event channelName");
        }
        if (listener == null) {
            throw new IllegalArgumentException("Cannot bind or unbind to channel " + this.channelName + " with a null listener");
        }
        if (eventName.startsWith(INTERNAL_EVENT_PREFIX)) {
            throw new IllegalArgumentException("Cannot bind or unbind channel " + this.channelName + " with an internal event channelName such as " + eventName);
        }
        if (this.state == ChannelState.UNSUBSCRIBED) {
            throw new IllegalStateException("Cannot bind or unbind to events on a channel that has been unsubscribed. Call Pusher.subscribe() to resubscribe to this channel");
        }
    }
}

