/*
 * Decompiled with CFR 0.152.
 */
package com.pusher.client.util;

import com.pusher.client.Authorizer;
import com.pusher.client.PusherOptions;
import com.pusher.client.channel.impl.ChannelImpl;
import com.pusher.client.channel.impl.ChannelManager;
import com.pusher.client.channel.impl.PresenceChannelImpl;
import com.pusher.client.channel.impl.PrivateChannelImpl;
import com.pusher.client.connection.impl.InternalConnection;
import com.pusher.client.connection.websocket.WebSocketConnection;
import java.net.URISyntaxException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;

public class Factory {
    private InternalConnection connection;
    private ChannelManager channelManager;
    private ExecutorService eventQueue;
    private ScheduledExecutorService timers;

    public synchronized InternalConnection getConnection(String apiKey, PusherOptions options) {
        if (this.connection == null) {
            try {
                this.connection = new WebSocketConnection(options.getHttpClient(), options.buildUrl(apiKey), options.getActivityTimeout(), options.getPongTimeout(), options.getMaxReconnectionAttempts(), options.getMaxReconnectGapInSeconds(), this);
            }
            catch (URISyntaxException e) {
                throw new IllegalArgumentException("Failed to initialise connection", e);
            }
        }
        return this.connection;
    }

    public synchronized ScheduledExecutorService getTimers() {
        if (this.timers == null) {
            this.timers = Executors.newSingleThreadScheduledExecutor(new DaemonThreadFactory("timers"));
        }
        return this.timers;
    }

    public ChannelImpl newPublicChannel(String channelName) {
        return new ChannelImpl(channelName, this);
    }

    public PrivateChannelImpl newPrivateChannel(InternalConnection connection, String channelName, Authorizer authorizer) {
        return new PrivateChannelImpl(connection, channelName, authorizer, this);
    }

    public PresenceChannelImpl newPresenceChannel(InternalConnection connection, String channelName, Authorizer authorizer) {
        return new PresenceChannelImpl(connection, channelName, authorizer, this);
    }

    public synchronized ChannelManager getChannelManager() {
        if (this.channelManager == null) {
            this.channelManager = new ChannelManager(this);
        }
        return this.channelManager;
    }

    public synchronized void queueOnEventThread(Runnable r) {
        if (this.eventQueue == null) {
            this.eventQueue = Executors.newSingleThreadExecutor(new DaemonThreadFactory("eventQueue"));
        }
        this.eventQueue.execute(r);
    }

    public synchronized void shutdownThreads() {
        if (this.eventQueue != null) {
            this.eventQueue.shutdown();
            this.eventQueue = null;
        }
        if (this.timers != null) {
            this.timers.shutdown();
            this.timers = null;
        }
    }

    private static class DaemonThreadFactory
    implements ThreadFactory {
        private final String name;

        DaemonThreadFactory(String name) {
            this.name = name;
        }

        @Override
        public Thread newThread(Runnable r) {
            Thread t = new Thread(r);
            t.setDaemon(true);
            t.setName("pusher-java-client " + this.name);
            return t;
        }
    }
}

