/*
 * Decompiled with CFR 0.152.
 */
package com.pusher.client.example;

import com.pusher.client.Pusher;
import com.pusher.client.PusherOptions;
import com.pusher.client.channel.PrivateChannel;
import com.pusher.client.channel.PrivateChannelEventListener;
import com.pusher.client.connection.ConnectionEventListener;
import com.pusher.client.connection.ConnectionState;
import com.pusher.client.connection.ConnectionStateChange;
import com.pusher.client.util.HttpAuthorizer;
import jdk.incubator.http.HttpClient;

public class PrivateChannelExampleApp
implements ConnectionEventListener,
PrivateChannelEventListener {
    private final Pusher pusher;
    private final String channelName;
    private final String eventName;
    private final PrivateChannel channel;

    public static void main(String[] args) {
        new PrivateChannelExampleApp(args);
    }

    public PrivateChannelExampleApp(String[] args) {
        String apiKey = args.length > 0 ? args[0] : "a87fe72c6f36272aa4b1";
        this.channelName = args.length > 1 ? args[1] : "private-my-channel";
        this.eventName = args.length > 2 ? args[2] : "my-event";
        HttpClient httpClient = HttpClient.newBuilder().build();
        HttpAuthorizer authorizer = new HttpAuthorizer(httpClient, "http://www.leggetter.co.uk/pusher/pusher-examples/php/authentication/src/private_auth.php");
        PusherOptions options = new PusherOptions().setHttpClient(httpClient).setAuthorizer(authorizer);
        this.pusher = new Pusher(apiKey, options);
        this.pusher.connect(this, new ConnectionState[0]);
        this.channel = this.pusher.subscribePrivate(this.channelName, this, this.eventName);
        try {
            Thread.sleep(Long.MAX_VALUE);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void onConnectionStateChange(ConnectionStateChange change) {
        System.out.println(String.format("Connection state changed from [%s] to [%s]", new Object[]{change.getPreviousState(), change.getCurrentState()}));
    }

    @Override
    public void onError(String message, String code, Throwable e) {
        System.out.println(String.format("An error was received with message [%s], code [%s], exception [%s]", message, code, e));
    }

    @Override
    public void onEvent(String channelName, String eventName, String data) {
        System.out.println(String.format("Received event [%s] on channel [%s] with data [%s]", eventName, channelName, data));
    }

    @Override
    public void onSubscriptionSucceeded(String channelName) {
        System.out.println(String.format("Subscription to channel [%s] succeeded", this.channel.getChannelName()));
        this.channel.trigger("client-myEvent", "{\"myName\":\"Bob\"}");
    }

    @Override
    public void onAuthenticationFailure(String message, Exception e) {
        System.out.println(String.format("Authentication failure due to [%s], exception was [%s]", message, e));
    }
}

