package com.pusher.client.util;

public final class PusherJsonParser {

  private PusherJsonParser() {
  }

  public static String getEscapedJsonValue(final String json, final String field) {
    final var fieldIndex = json.indexOf(field);
    if (fieldIndex < 0) {
      return null;
    }
    for (var index = fieldIndex + field.length(); ; ) {
      final var ch = json.charAt(index++);
      if (ch == ':' || Character.isSpaceChar(ch)) {
        continue;
      }
      if (ch == '\\') {
        ++index;
        return json.substring(index, json.indexOf("\\\"", index));
      }
      if(ch == '{') {
        final var begin = index - 1;
        for (var openCount = 1; ; ) {
          final var ch2 = json.charAt(index++);
          if (ch2 == '{') {
            openCount++;
            continue;
          }
          if (ch2 == '}' && --openCount == 0) {
            return json.substring(begin, index);
          }
        }
      }
      for (final var begin = index - 1; ; index++) {
        final var ch2 = json.charAt(index);
        if (ch2 == ',' || Character.isSpaceChar(ch2)) {
          return json.substring(begin, index);
        }
      }
    }
  }

  public static String getJsonValue(final String json, final String field) {
    final var fieldIndex = json.indexOf(field);
    if (fieldIndex < 0) {
      return null;
    }
    for (var index = fieldIndex + field.length(); ; ) {
      final var ch = json.charAt(index++);
      if (ch == ':' || Character.isSpaceChar(ch)) {
        continue;
      }
      if (ch == '"') {
        return json.substring(index, json.indexOf('"', index));
      }
      if(ch == '{') {
        final var begin = index - 1;
        for (var openCount = 1; ; ) {
          final var ch2 = json.charAt(index++);
          if (ch2 == '{') {
            openCount++;
            continue;
          }
          if (ch2 == '}' && --openCount == 0) {
            return json.substring(begin, index);
          }
        }
      }
      for (final var begin = index - 1; ; index++) {
        final var ch2 = json.charAt(index);
        if (ch2 == ',' || Character.isSpaceChar(ch2)) {
          return json.substring(begin, index);
        }
      }
    }
  }
}
