/*
 * Decompiled with CFR 0.152.
 */
package com.pusher.client;

import com.pusher.client.Authorizer;
import java.io.InputStream;
import java.util.Properties;
import jdk.incubator.http.HttpClient;

public final class PusherOptions {
    private static final String SRC_LIB_DEV_VERSION = "@version@";
    private static final String LIB_DEV_VERSION = "0.0.0-dev";
    public static final String LIB_VERSION = PusherOptions.readVersionFromProperties();
    private static final String URI_SUFFIX = "?client=java-client&protocol=5&version=" + LIB_VERSION;
    private static final String WS_SCHEME = "ws";
    private static final String WSS_SCHEME = "wss";
    private static final int WS_PORT = 80;
    private static final int WSS_PORT = 443;
    private static final String PUSHER_DOMAIN = "pusher.com";
    private static final long DEFAULT_ACTIVITY_TIMEOUT = 120000L;
    private static final long DEFAULT_PONG_TIMEOUT = 30000L;
    private static final int MAX_RECONNECTION_ATTEMPTS = 6;
    private static final int MAX_RECONNECT_GAP_IN_SECONDS = 30;
    private String host = "ws.pusherapp.com";
    private int wsPort = 80;
    private int wssPort = 443;
    private boolean encrypted = true;
    private long activityTimeout = 120000L;
    private long pongTimeout = 30000L;
    private Authorizer authorizer;
    private int maxReconnectionAttempts = 6;
    private int maxReconnectGapInSeconds = 30;
    private HttpClient httpClient;

    public HttpClient getHttpClient() {
        return this.httpClient;
    }

    public PusherOptions setHttpClient(HttpClient httpClient) {
        this.httpClient = httpClient;
        return this;
    }

    public boolean isEncrypted() {
        return this.encrypted;
    }

    public PusherOptions setEncrypted(boolean encrypted) {
        this.encrypted = encrypted;
        return this;
    }

    public Authorizer getAuthorizer() {
        return this.authorizer;
    }

    public PusherOptions setAuthorizer(Authorizer authorizer) {
        this.authorizer = authorizer;
        return this;
    }

    public PusherOptions setHost(String host) {
        this.host = host;
        return this;
    }

    public PusherOptions setWsPort(int wsPort) {
        this.wsPort = wsPort;
        return this;
    }

    public PusherOptions setWssPort(int wssPort) {
        this.wssPort = wssPort;
        return this;
    }

    public PusherOptions setCluster(String cluster) {
        this.host = "ws-" + cluster + ".pusher.com";
        this.wsPort = 80;
        this.wssPort = 443;
        return this;
    }

    public PusherOptions setActivityTimeout(long activityTimeout) {
        if (activityTimeout < 1000L) {
            throw new IllegalArgumentException("Activity timeout must be at least 1,000ms (and is recommended to be much higher)");
        }
        this.activityTimeout = activityTimeout;
        return this;
    }

    public long getActivityTimeout() {
        return this.activityTimeout;
    }

    public PusherOptions setPongTimeout(long pongTimeout) {
        if (pongTimeout < 1000L) {
            throw new IllegalArgumentException("Pong timeout must be at least 1,000ms (and is recommended to be much higher)");
        }
        this.pongTimeout = pongTimeout;
        return this;
    }

    public PusherOptions setMaxReconnectionAttempts(int maxReconnectionAttempts) {
        this.maxReconnectionAttempts = maxReconnectionAttempts;
        return this;
    }

    public PusherOptions setMaxReconnectGapInSeconds(int maxReconnectGapInSeconds) {
        this.maxReconnectGapInSeconds = maxReconnectGapInSeconds;
        return this;
    }

    public long getPongTimeout() {
        return this.pongTimeout;
    }

    public String buildUrl(String apiKey) {
        return String.format("%s://%s:%s/app/%s%s", this.encrypted ? WSS_SCHEME : WS_SCHEME, this.host, this.encrypted ? this.wssPort : this.wsPort, apiKey, URI_SUFFIX);
    }

    public int getMaxReconnectionAttempts() {
        return this.maxReconnectionAttempts;
    }

    public int getMaxReconnectGapInSeconds() {
        return this.maxReconnectGapInSeconds;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static String readVersionFromProperties() {
        try (InputStream inStream = PusherOptions.class.getResourceAsStream("/pusher.properties");){
            Properties p = new Properties();
            p.load(inStream);
            String version = (String)p.get("version");
            if (version == null) return "0.0.0";
            if (version.isEmpty()) return "0.0.0";
            String string = version.equals(SRC_LIB_DEV_VERSION) ? LIB_DEV_VERSION : version;
            return string;
        }
        catch (Exception exception) {
            // empty catch block
        }
        return "0.0.0";
    }
}

