/*
 * Decompiled with CFR 0.152.
 */
package systems.comodal.pagerduty.event.client.jsoniter.adapter;

import java.net.http.HttpResponse;
import systems.comodal.jsoniter.ContextFieldBufferPredicate;
import systems.comodal.jsoniter.JsonIterator;
import systems.comodal.pagerduty.event.data.PagerDutyEventResponse;
import systems.comodal.pagerduty.event.data.adapters.PagerDutyEventAdapter;
import systems.comodal.pagerduty.exceptions.PagerDutyClientException;
import systems.comodal.pagerduty.exceptions.PagerDutyParseException;
import systems.comodal.pagerduty.exceptions.PagerDutyRequestException;

final class JsonIteratorPagerDutyEventAdapter
implements PagerDutyEventAdapter {
    static final JsonIteratorPagerDutyEventAdapter INSTANCE = new JsonIteratorPagerDutyEventAdapter();
    private static final ContextFieldBufferPredicate<PagerDutyEventResponse.Builder> EVENT_RESPONSE_PARSER = (response, buf, offset, len, ji) -> {
        if (JsonIterator.fieldEquals((String)"status", (char[])buf, (int)offset, (int)len)) {
            response.status(ji.readString());
        } else if (JsonIterator.fieldEquals((String)"message", (char[])buf, (int)offset, (int)len)) {
            response.message(ji.readString());
        } else if (JsonIterator.fieldEquals((String)"dedup_key", (char[])buf, (int)offset, (int)len)) {
            response.dedupKey(ji.readString());
        } else {
            ji.skip();
        }
        return true;
    };
    private static final ContextFieldBufferPredicate<PagerDutyRequestException.Builder> EXCEPTION_PARSER = (exception, buf, offset, len, ji) -> {
        if (JsonIterator.fieldEquals((String)"status", (char[])buf, (int)offset, (int)len)) {
            exception.status(ji.readString());
        } else if (JsonIterator.fieldEquals((String)"message", (char[])buf, (int)offset, (int)len)) {
            exception.message(ji.readString());
        } else if (JsonIterator.fieldEquals((String)"code", (char[])buf, (int)offset, (int)len)) {
            exception.message(ji.readString());
        } else if (JsonIterator.fieldEquals((String)"errors", (char[])buf, (int)offset, (int)len)) {
            while (ji.readArray()) {
                exception.error(ji.readString());
            }
        } else {
            ji.skip();
        }
        return true;
    };

    private JsonIteratorPagerDutyEventAdapter() {
    }

    public RuntimeException errorResponse(HttpResponse<byte[]> response) {
        PagerDutyRequestException responseError;
        PagerDutyRequestException.Builder exception = PagerDutyRequestException.build(response);
        if (response.statusCode() == 429) {
            throw exception.message("Too many requests").create();
        }
        if (response.statusCode() == 404) {
            throw exception.message(response.request().uri() + " Not Found").create();
        }
        if (response.statusCode() == 400) {
            exception.message("Bad Request - Check that the JSON is valid.");
        } else if (response.statusCode() == 401) {
            exception.message("Unauthorized");
        } else if (response.statusCode() == 402) {
            exception.message("Payment Required");
        } else if (response.statusCode() == 403) {
            exception.message("Forbidden");
        } else if (response.statusCode() >= 500 && response.statusCode() < 600) {
            exception.message("Internal Server Error - the PagerDuty server experienced an error while processing the event.");
        }
        JsonIterator ji = JsonIterator.parse((byte[])response.body());
        try {
            responseError = ((PagerDutyRequestException.Builder)ji.testObject((Object)exception, EXCEPTION_PARSER)).create();
        }
        catch (RuntimeException runtimeCause) {
            try {
                throw new PagerDutyParseException(response, String.format("Failed to adapt %d error response: '%s'", response.statusCode(), ji.currentBuffer()), (Throwable)runtimeCause);
            }
            catch (RuntimeException ex) {
                throw new PagerDutyParseException(response, String.format("Failed to adapt %d error response: '%s'", response.statusCode(), new String(response.body())), (Throwable)runtimeCause);
            }
        }
        throw responseError;
    }

    public PagerDutyEventResponse adaptResponse(HttpResponse<byte[]> response) {
        this.verifyHttpResponseCode(response);
        JsonIterator ji = JsonIterator.parse((byte[])response.body());
        try {
            return ((PagerDutyEventResponse.Builder)ji.testObject((Object)PagerDutyEventResponse.build(), EVENT_RESPONSE_PARSER)).create();
        }
        catch (RuntimeException runtimeCause) {
            if (runtimeCause instanceof PagerDutyClientException) {
                throw runtimeCause;
            }
            try {
                throw new PagerDutyParseException(response, (Throwable)runtimeCause, ji.currentBuffer());
            }
            catch (RuntimeException ex) {
                throw new PagerDutyParseException(response, "Failed to adapt event response.", (Throwable)runtimeCause);
            }
        }
    }
}

