/*
 * Decompiled with CFR 0.152.
 */
package systems.comodal.pagerduty.event.client.jsoniter.adapter;

import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.net.http.HttpResponse;
import java.util.concurrent.ConcurrentLinkedQueue;
import systems.comodal.jsoniter.ContextFieldBufferPredicate;
import systems.comodal.jsoniter.JsonIterator;
import systems.comodal.pagerduty.event.data.PagerDutyEventResponse;
import systems.comodal.pagerduty.event.data.adapters.PagerDutyEventAdapter;
import systems.comodal.pagerduty.exceptions.PagerDutyParseException;
import systems.comodal.pagerduty.exceptions.PagerDutyRequestException;

final class JsonIteratorPagerDutyEventAdapter
implements PagerDutyEventAdapter {
    static final JsonIteratorPagerDutyEventAdapter INSTANCE = new JsonIteratorPagerDutyEventAdapter();
    private static final ConcurrentLinkedQueue<JsonIterator> JSON_ITERATOR_POOL = new ConcurrentLinkedQueue();
    private static final ContextFieldBufferPredicate<PagerDutyEventResponse.Builder> EVENT_RESPONSE_PARSER = (response, buf, offset, len, ji) -> {
        if (JsonIterator.fieldEquals((String)"status", (char[])buf, (int)offset, (int)len)) {
            response.status(ji.readString());
        } else if (JsonIterator.fieldEquals((String)"message", (char[])buf, (int)offset, (int)len)) {
            response.message(ji.readString());
        } else if (JsonIterator.fieldEquals((String)"dedup_key", (char[])buf, (int)offset, (int)len)) {
            response.dedupKey(ji.readString());
        } else {
            ji.skip();
        }
        return true;
    };
    private static final ContextFieldBufferPredicate<PagerDutyRequestException.Builder> EXCEPTION_PARSER = (exception, buf, offset, len, ji) -> {
        if (JsonIterator.fieldEquals((String)"status", (char[])buf, (int)offset, (int)len)) {
            exception.status(ji.readString());
        } else if (JsonIterator.fieldEquals((String)"message", (char[])buf, (int)offset, (int)len)) {
            exception.message(ji.readString());
        } else if (JsonIterator.fieldEquals((String)"errors", (char[])buf, (int)offset, (int)len)) {
            while (ji.readArray()) {
                exception.error(ji.readString());
            }
        } else {
            ji.skip();
        }
        return true;
    };

    private JsonIteratorPagerDutyEventAdapter() {
    }

    private static JsonIterator createInputStreamJsonIterator(InputStream inputStream) {
        JsonIterator ji = JSON_ITERATOR_POOL.poll();
        return ji == null ? JsonIterator.parse((InputStream)inputStream, (int)1024) : ji.reset(inputStream);
    }

    private static void returnJsonIterator(JsonIterator ji) {
        JSON_ITERATOR_POOL.add(ji);
    }

    private static JsonIterator createInputStreamJsonIterator(HttpResponse<InputStream> response) {
        return JsonIteratorPagerDutyEventAdapter.createInputStreamJsonIterator(response.body());
    }

    public RuntimeException errorResponse(HttpResponse<InputStream> response) {
        PagerDutyRequestException.Builder exception = PagerDutyRequestException.build(response);
        if (response.statusCode() == 429) {
            throw exception.message("Too many requests").create();
        }
        if (response.statusCode() == 404) {
            throw exception.message(response.request().uri() + " Not Found").create();
        }
        if (response.statusCode() == 400) {
            exception.message("Bad Request - Check that the JSON is valid.");
        } else if (response.statusCode() == 401) {
            exception.message("Unauthorized");
        } else if (response.statusCode() == 402) {
            exception.message("Payment Required");
        } else if (response.statusCode() == 403) {
            exception.message("Forbidden");
        } else if (response.statusCode() >= 500 && response.statusCode() < 600) {
            exception.message("Internal Server Error - the PagerDuty server experienced an error while processing the event.");
        }
        try {
            JsonIterator ji = JsonIteratorPagerDutyEventAdapter.createInputStreamJsonIterator(response);
            try {
                try {
                    try {
                        throw this.adaptException(exception, ji);
                    }
                    catch (RuntimeException runtimeCause) {
                        throw new PagerDutyParseException(response, (Throwable)runtimeCause, ji.currentBuffer());
                    }
                }
                catch (Throwable throwable) {
                    JsonIteratorPagerDutyEventAdapter.returnJsonIterator(ji);
                    throw throwable;
                }
            }
            catch (Throwable throwable) {
                if (ji != null) {
                    try {
                        ji.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
        }
        catch (IOException ioEx) {
            throw new UncheckedIOException(ioEx);
        }
        catch (RuntimeException runtimeCause) {
            throw new PagerDutyParseException(response, "Failed to adapt error response.", (Throwable)runtimeCause);
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive exception aggregation
     */
    public PagerDutyEventResponse adaptResponse(HttpResponse<InputStream> response) {
        this.verifyHttpResponseCode(response);
        try (JsonIterator ji = JsonIteratorPagerDutyEventAdapter.createInputStreamJsonIterator(response);){
            try {
                PagerDutyEventResponse pagerDutyEventResponse = this.adaptResponse(ji);
                return pagerDutyEventResponse;
            }
            catch (RuntimeException runtimeCause) {
                throw new PagerDutyParseException(response, (Throwable)runtimeCause, ji.currentBuffer());
            }
            finally {
                JsonIteratorPagerDutyEventAdapter.returnJsonIterator(ji);
            }
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
        catch (IOException ioEx) {
            throw new UncheckedIOException(ioEx);
        }
        catch (RuntimeException runtimeCause) {
            throw new PagerDutyParseException(response, "Failed to adapt event response.", (Throwable)runtimeCause);
        }
    }

    private PagerDutyEventResponse adaptResponse(JsonIterator ji) {
        return ((PagerDutyEventResponse.Builder)ji.testObject((Object)PagerDutyEventResponse.build(), EVENT_RESPONSE_PARSER)).create();
    }

    private PagerDutyRequestException adaptException(PagerDutyRequestException.Builder exception, JsonIterator ji) {
        return ((PagerDutyRequestException.Builder)ji.testObject((Object)exception, EXCEPTION_PARSER)).create();
    }
}

