/*
 * Decompiled with CFR 0.152.
 */
package systems.comodal.pagerduty.event.client.jsoniter.adapter;

import java.io.IOException;
import java.io.InputStream;
import java.net.http.HttpResponse;
import java.util.concurrent.ConcurrentLinkedQueue;
import systems.comodal.jsoniter.ContextFieldBufferPredicate;
import systems.comodal.jsoniter.JsonException;
import systems.comodal.jsoniter.JsonIterator;
import systems.comodal.pagerduty.event.data.PagerDutyEventResponse;
import systems.comodal.pagerduty.event.data.adapters.PagerDutyEventAdapter;
import systems.comodal.pagerduty.exceptions.PagerDutyParseException;
import systems.comodal.pagerduty.exceptions.PagerDutyRequestException;

final class JsonIteratorPagerDutyEventAdapter
implements PagerDutyEventAdapter {
    static final JsonIteratorPagerDutyEventAdapter INSTANCE = new JsonIteratorPagerDutyEventAdapter();
    private static final ConcurrentLinkedQueue<JsonIterator> JSON_ITERATOR_POOL = new ConcurrentLinkedQueue();
    private static final ContextFieldBufferPredicate<PagerDutyEventResponse.Builder> EVENT_RESPONSE_PARSER = (response, len, buf, ji) -> {
        if (JsonIterator.fieldEquals((String)"status", (char[])buf, (int)len)) {
            response.status(ji.readString());
        } else if (JsonIterator.fieldEquals((String)"message", (char[])buf, (int)len)) {
            response.message(ji.readString());
        } else if (JsonIterator.fieldEquals((String)"dedup_key", (char[])buf, (int)len)) {
            response.dedupeKey(ji.readString());
        } else {
            ji.skip();
        }
        return true;
    };
    private static final ContextFieldBufferPredicate<PagerDutyRequestException.Builder> EXCEPTION_PARSER = (exception, len, buf, ji) -> {
        if (JsonIterator.fieldEquals((String)"status", (char[])buf, (int)len)) {
            exception.status(ji.readString());
        } else if (JsonIterator.fieldEquals((String)"message", (char[])buf, (int)len)) {
            exception.message(ji.readString());
        } else if (JsonIterator.fieldEquals((String)"errors", (char[])buf, (int)len)) {
            while (ji.readArray()) {
                exception.error(ji.readString());
            }
        } else {
            ji.skip();
        }
        return true;
    };

    private JsonIteratorPagerDutyEventAdapter() {
    }

    private static JsonIterator createInputStreamJsonIterator(InputStream inputStream) {
        JsonIterator ji = JSON_ITERATOR_POOL.poll();
        return ji == null ? JsonIterator.parse((InputStream)inputStream, (int)1024) : ji.reset(inputStream);
    }

    private static void returnJsonIterator(JsonIterator ji) {
        JSON_ITERATOR_POOL.add(ji);
    }

    private static JsonIterator createInputStreamJsonIterator(HttpResponse<InputStream> response) {
        return JsonIteratorPagerDutyEventAdapter.createInputStreamJsonIterator(response.body());
    }

    public RuntimeException errorResponse(HttpResponse<InputStream> response) {
        try {
            JsonIterator ji = JsonIteratorPagerDutyEventAdapter.createInputStreamJsonIterator(response);
            try {
                try {
                    try {
                        PagerDutyRequestException.Builder exception = PagerDutyRequestException.build(response);
                        if (response.statusCode() == 429) {
                            throw exception.message("Too many requests").create();
                        }
                        throw this.adaptException(exception, ji);
                    }
                    catch (IOException | NullPointerException | JsonException runtimeCause) {
                        throw new PagerDutyParseException(runtimeCause, ji.currentBuffer());
                    }
                }
                catch (Throwable throwable) {
                    JsonIteratorPagerDutyEventAdapter.returnJsonIterator(ji);
                    throw throwable;
                }
            }
            catch (Throwable throwable) {
                if (ji != null) {
                    try {
                        ji.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
        }
        catch (IOException ioEx) {
            throw new PagerDutyParseException((Throwable)ioEx);
        }
        catch (ArrayIndexOutOfBoundsException | NullPointerException | JsonException runtimeCause) {
            throw new PagerDutyParseException("Failed to adapt error response.", runtimeCause);
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive exception aggregation
     */
    public PagerDutyEventResponse adaptResponse(HttpResponse<InputStream> response) {
        this.verifyHttpResponseCode(response);
        try (JsonIterator ji = JsonIteratorPagerDutyEventAdapter.createInputStreamJsonIterator(response);){
            try {
                PagerDutyEventResponse pagerDutyEventResponse = this.adaptResponse(ji);
                return pagerDutyEventResponse;
            }
            catch (IOException | NullPointerException | JsonException runtimeCause) {
                throw new PagerDutyParseException(runtimeCause, ji.currentBuffer());
            }
            finally {
                JsonIteratorPagerDutyEventAdapter.returnJsonIterator(ji);
            }
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
        catch (IOException ioEx) {
            throw new PagerDutyParseException((Throwable)ioEx);
        }
        catch (ArrayIndexOutOfBoundsException | NullPointerException | JsonException runtimeCause) {
            throw new PagerDutyParseException("Failed to adapt event response.", runtimeCause);
        }
    }

    private PagerDutyEventResponse adaptResponse(JsonIterator ji) throws IOException {
        return ((PagerDutyEventResponse.Builder)ji.testObject((Object)PagerDutyEventResponse.build(), EVENT_RESPONSE_PARSER)).create();
    }

    private PagerDutyRequestException adaptException(PagerDutyRequestException.Builder exception, JsonIterator ji) throws IOException {
        return ((PagerDutyRequestException.Builder)ji.testObject((Object)exception, EXCEPTION_PARSER)).create();
    }
}

