/*
 * Decompiled with CFR 0.152.
 */
package systems.comodal.pagerduty.event.data;

import java.io.Serializable;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import systems.comodal.pagerduty.event.data.PagerDutyEventPayload;
import systems.comodal.pagerduty.event.data.PagerDutyEventPayloadVal;
import systems.comodal.pagerduty.event.data.PagerDutyImageRef;
import systems.comodal.pagerduty.event.data.PagerDutyLinkRef;
import systems.comodal.pagerduty.event.data.PagerDutySeverity;

final class PagerDutyEventPayloadBuilder
implements PagerDutyEventPayload.Builder {
    private String dedupKey;
    private String summary;
    private String source;
    private PagerDutySeverity severity;
    private ZonedDateTime timestamp;
    private String component;
    private String group;
    private String type;
    private Map<String, Object> customDetails;
    private List<PagerDutyLinkRef> links;
    private List<PagerDutyImageRef> images;

    PagerDutyEventPayloadBuilder() {
        this.customDetails = Map.of();
        this.links = List.of();
        this.images = List.of();
    }

    PagerDutyEventPayloadBuilder(PagerDutyEventPayload prototype) {
        this.dedupKey = prototype.getDedupKey();
        this.summary = prototype.getSummary();
        this.source = prototype.getSource();
        this.severity = prototype.getSeverity();
        this.timestamp = prototype.getTimestamp();
        this.component = prototype.getComponent();
        this.group = prototype.getGroup();
        this.type = prototype.getType();
        this.customDetails = prototype.getCustomDetails().size() > 1 ? new LinkedHashMap<String, Object>(prototype.getCustomDetails()) : Map.copyOf(prototype.getCustomDetails());
        this.links = prototype.getLinks().size() > 1 ? new ArrayList<PagerDutyLinkRef>(prototype.getLinks()) : List.copyOf(prototype.getLinks());
        this.images = prototype.getImages().size() > 1 ? new ArrayList<PagerDutyImageRef>(prototype.getImages()) : List.copyOf(prototype.getImages());
    }

    @Override
    public PagerDutyEventPayload create() {
        return new PagerDutyEventPayloadVal(this.dedupKey == null || this.dedupKey.isBlank() ? UUID.randomUUID().toString() : this.dedupKey, Objects.requireNonNull(this.summary, "'Summary' is a required payload field."), Objects.requireNonNull(this.source, "'Source' is a required payload field."), Objects.requireNonNull(this.severity, "'Severity' is a required payload field."), this.timestamp == null ? ZonedDateTime.now(ZoneOffset.UTC) : this.timestamp, this.component, this.group, this.type, this.getCustomDetails(), this.links, this.images);
    }

    @Override
    public PagerDutyEventPayload.Builder dedupKey(String dedupKey) {
        this.dedupKey = dedupKey;
        return this;
    }

    @Override
    public PagerDutyEventPayload.Builder summary(String summary) {
        this.summary = summary;
        return this;
    }

    @Override
    public PagerDutyEventPayload.Builder source(String source) {
        this.source = source;
        return this;
    }

    @Override
    public PagerDutyEventPayload.Builder severity(PagerDutySeverity severity) {
        this.severity = severity;
        return this;
    }

    @Override
    public PagerDutyEventPayload.Builder timestamp(ZonedDateTime timestamp) {
        this.timestamp = timestamp;
        return this;
    }

    @Override
    public PagerDutyEventPayload.Builder component(String component) {
        this.component = component;
        return this;
    }

    @Override
    public PagerDutyEventPayload.Builder group(String group) {
        this.group = group;
        return this;
    }

    @Override
    public PagerDutyEventPayload.Builder type(String type) {
        this.type = type;
        return this;
    }

    private PagerDutyEventPayload.Builder customDetailsObject(String field, Object fieldValue) {
        if (this.customDetails == null || this.customDetails.isEmpty()) {
            this.customDetails = Map.of(field, fieldValue == null ? "null" : fieldValue);
            return this;
        }
        if (this.customDetails.size() == 1) {
            this.customDetails = new LinkedHashMap<String, Object>(this.customDetails);
        }
        this.customDetails.put(field, fieldValue == null ? "null" : fieldValue);
        return this;
    }

    @Override
    public PagerDutyEventPayload.Builder customDetails(String field, String fieldValue) {
        return this.customDetailsObject(field, fieldValue);
    }

    @Override
    public PagerDutyEventPayload.Builder customDetails(String field, Boolean fieldValue) {
        return this.customDetailsObject(field, fieldValue);
    }

    @Override
    public PagerDutyEventPayload.Builder customDetails(String field, Number fieldValue) {
        return this.customDetailsObject(field, fieldValue);
    }

    @Override
    public PagerDutyEventPayload.Builder link(PagerDutyLinkRef link) {
        if (this.links.isEmpty()) {
            this.links = List.of(link);
            return this;
        }
        if (this.links.size() == 1) {
            this.links = new ArrayList<PagerDutyLinkRef>(this.links);
        }
        this.links.add(link);
        return this;
    }

    @Override
    public PagerDutyEventPayload.Builder image(PagerDutyImageRef image) {
        if (this.images.isEmpty()) {
            this.images = List.of(image);
            return this;
        }
        if (this.images.size() == 1) {
            this.images = new ArrayList<PagerDutyImageRef>(this.images);
        }
        this.images.add(image);
        return this;
    }

    @Override
    public String getDedupKey() {
        return this.dedupKey;
    }

    @Override
    public String getSummary() {
        return this.summary;
    }

    @Override
    public String getSource() {
        return this.source;
    }

    @Override
    public PagerDutySeverity getSeverity() {
        return this.severity;
    }

    @Override
    public ZonedDateTime getTimestamp() {
        return this.timestamp;
    }

    @Override
    public String getComponent() {
        return this.component;
    }

    @Override
    public String getGroup() {
        return this.group;
    }

    @Override
    public String getType() {
        return this.type;
    }

    @Override
    public Map<String, Object> getCustomDetails() {
        return this.customDetails == null ? Map.of() : this.customDetails;
    }

    @Override
    public List<PagerDutyLinkRef> getLinks() {
        return this.links;
    }

    @Override
    public List<PagerDutyImageRef> getImages() {
        return this.images;
    }

    @Override
    public String getPayloadJson() {
        return "{\"summary\":\"" + this.summary + "\",\"source\":\"" + this.source + "\",\"severity\":\"" + this.severity + "\",\"timestamp\":\"" + this.timestamp + (Serializable)(this.component == null ? Character.valueOf('\"') : "\",\"component\":\"" + this.component + "\"") + (String)(this.group == null ? "" : ",\"group\":\"" + this.group + "\"") + (String)(this.type == null ? "" : ",\"type\":\"" + this.type + "\"") + (String)(this.customDetails == null ? "" : ",\"custom_details\":" + PagerDutyEventPayloadVal.toJson(this.customDetails)) + "}";
    }

    public String toString() {
        return this.getPayloadJson();
    }
}

