/*
 * Decompiled with CFR 0.152.
 */
package systems.comodal.pagerduty.event.service;

import java.time.Duration;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.function.LongUnaryOperator;
import systems.comodal.pagerduty.event.client.PagerDutyEventClient;
import systems.comodal.pagerduty.event.data.PagerDutyEventPayload;
import systems.comodal.pagerduty.event.data.PagerDutyEventResponse;
import systems.comodal.pagerduty.event.service.PagerDutyService;
import systems.comodal.pagerduty.exceptions.PagerDutyClientException;

final class PagerDutyServiceVal
implements PagerDutyService {
    private static final System.Logger log = System.getLogger(PagerDutyService.class.getPackageName());
    private final PagerDutyEventClient client;
    private final PagerDutyEventPayload eventPrototype;

    PagerDutyServiceVal(PagerDutyEventClient client, PagerDutyEventPayload eventPrototype) {
        this.client = client;
        this.eventPrototype = eventPrototype;
    }

    @Override
    public PagerDutyEventClient getClient() {
        return this.client;
    }

    @Override
    public PagerDutyEventPayload getEventPrototype() {
        return this.eventPrototype;
    }

    private void logFailure(Throwable throwable, int numFailures, long retryDelay, TimeUnit timeUnit, String context) {
        if (throwable.getCause() instanceof PagerDutyClientException) {
            PagerDutyClientException pdException = (PagerDutyClientException)((Object)throwable.getCause());
            log.log(System.Logger.Level.ERROR, String.format("Http Error Code: %s, Service Error Code: %s, Failure Count: %d, Last Delay: %d %s, Service Errors: %s, %s", new Object[]{pdException.getHttpResponse() == null ? "?" : String.valueOf(pdException.getHttpResponse().statusCode()), pdException.getErrorCode() == 0L ? "?" : String.valueOf(pdException.getErrorCode()), numFailures, retryDelay, timeUnit, pdException.getErrors().toString(), context}), throwable.getCause());
        } else {
            log.log(System.Logger.Level.ERROR, String.format("Failure Count: %d, Last Delay: %d %s, %s", new Object[]{numFailures, retryDelay, timeUnit, context}), throwable.getCause());
        }
    }

    @Override
    public CompletableFuture<PagerDutyEventResponse> resolveEvent(String dedupeKey, long stepDelay, long maxDelay, TimeUnit timeUnit) {
        return dedupeKey == null ? null : this.resolveEvent(dedupeKey, 0, PagerDutyService.createRetryDelayFn(stepDelay, maxDelay), timeUnit);
    }

    @Override
    public CompletableFuture<PagerDutyEventResponse> resolveEvent(String dedupeKey, Duration giveUpAfter, long stepDelay, long maxDelay, TimeUnit timeUnit) {
        if (dedupeKey == null) {
            return null;
        }
        int maxRetries = (int)Math.min(Integer.MAX_VALUE, giveUpAfter.toMillis() / timeUnit.toMillis(stepDelay));
        return this.resolveEvent(dedupeKey, 0, PagerDutyService.createRetryDelayFn(maxRetries, stepDelay, maxDelay), timeUnit);
    }

    @Override
    public CompletableFuture<PagerDutyEventResponse> resolveEvent(String dedupeKey, int maxRetries, long stepDelay, long maxDelay, TimeUnit timeUnit) {
        return dedupeKey == null ? null : this.resolveEvent(dedupeKey, 0, PagerDutyService.createRetryDelayFn(maxRetries, stepDelay, maxDelay), timeUnit);
    }

    @Override
    public CompletableFuture<PagerDutyEventResponse> resolveEvent(String dedupeKey, LongUnaryOperator retryDelayFn, TimeUnit timeUnit) {
        return dedupeKey == null ? null : this.resolveEvent(dedupeKey, 0, retryDelayFn, timeUnit);
    }

    private CompletableFuture<PagerDutyEventResponse> resolveEvent(String dedupeKey, int retry, LongUnaryOperator retryDelayFn, TimeUnit timeUnit) {
        long retryDelay = retryDelayFn.applyAsLong(retry);
        if (retryDelay < 0L) {
            return null;
        }
        CompletableFuture<PagerDutyEventResponse> responseFuture = this.client.resolveEvent(dedupeKey);
        Function<Throwable, CompletableFuture> exceptionally = throwable -> {
            int numFailures = retry + 1;
            this.logFailure((Throwable)throwable, numFailures, retryDelay, timeUnit, String.format("to resolve event with dedupe key '%s'.", dedupeKey));
            return PagerDutyServiceVal.canBeRetried(throwable) ? this.resolveEvent(dedupeKey, numFailures, retryDelayFn, timeUnit) : null;
        };
        if (retryDelay > 0L) {
            return responseFuture.exceptionallyComposeAsync(exceptionally, CompletableFuture.delayedExecutor(retryDelay, timeUnit));
        }
        return responseFuture.exceptionallyCompose(exceptionally);
    }

    private static boolean canBeRetried(Throwable throwable) {
        if (throwable instanceof PagerDutyClientException) {
            return ((PagerDutyClientException)((Object)throwable)).canBeRetried();
        }
        if (throwable.getCause() instanceof PagerDutyClientException) {
            return ((PagerDutyClientException)((Object)throwable.getCause())).canBeRetried();
        }
        return true;
    }

    @Override
    public CompletableFuture<PagerDutyEventResponse> triggerEvent(PagerDutyEventPayload payload, long stepDelay, long maxDelay, TimeUnit timeUnit) {
        return this.triggerEvent(payload, 0, PagerDutyService.createRetryDelayFn(stepDelay, maxDelay), timeUnit);
    }

    @Override
    public CompletableFuture<PagerDutyEventResponse> triggerEvent(PagerDutyEventPayload payload, Duration giveUpAfter, long stepDelay, long maxDelay, TimeUnit timeUnit) {
        int maxRetries = (int)Math.min(Integer.MAX_VALUE, giveUpAfter.toMillis() / timeUnit.toMillis(stepDelay));
        return this.triggerEvent(payload, 0, PagerDutyService.createRetryDelayFn(maxRetries, stepDelay, maxDelay), timeUnit);
    }

    @Override
    public CompletableFuture<PagerDutyEventResponse> triggerEvent(PagerDutyEventPayload payload, int maxRetries, long stepDelay, long maxDelay, TimeUnit timeUnit) {
        return this.triggerEvent(payload, 0, PagerDutyService.createRetryDelayFn(maxRetries, stepDelay, maxDelay), timeUnit);
    }

    @Override
    public CompletableFuture<PagerDutyEventResponse> triggerEvent(PagerDutyEventPayload payload, LongUnaryOperator retryDelayFn, TimeUnit timeUnit) {
        return this.triggerEvent(payload, 0, retryDelayFn, timeUnit);
    }

    private CompletableFuture<PagerDutyEventResponse> triggerEvent(PagerDutyEventPayload payload, int retry, LongUnaryOperator retryDelayFn, TimeUnit timeUnit) {
        long retryDelay = retryDelayFn.applyAsLong(retry);
        if (retryDelay < 0L) {
            return null;
        }
        CompletableFuture<PagerDutyEventResponse> responseFuture = this.client.triggerDefaultRouteEvent(payload);
        Function<Throwable, CompletableFuture> exceptionally = throwable -> {
            int numFailures = retry + 1;
            this.logFailure((Throwable)throwable, numFailures, retryDelay, timeUnit, String.format("to trigger event:%n  %s", payload));
            return PagerDutyServiceVal.canBeRetried(throwable) ? this.triggerEvent(payload, numFailures, retryDelayFn, timeUnit) : null;
        };
        if (retryDelay > 0L) {
            return responseFuture.exceptionallyComposeAsync(exceptionally, CompletableFuture.delayedExecutor(retryDelay, timeUnit));
        }
        return responseFuture.exceptionallyCompose(exceptionally);
    }

    public String toString() {
        return "PagerdutyServiceVal{client=" + this.client + ", eventPrototype=" + this.eventPrototype + "}";
    }
}

