/*
 * Decompiled with CFR 0.152.
 */
package systems.comodal.pagerduty.exceptions;

import java.net.http.HttpResponse;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import systems.comodal.pagerduty.exceptions.PagerDutyClientException;

public final class PagerDutyRequestException
extends RuntimeException
implements PagerDutyClientException {
    private final String status;
    private final long errorCode;
    private final List<String> errors;
    private final HttpResponse<?> httpResponse;

    private PagerDutyRequestException(String status, String message, long errorCode, List<String> errors, HttpResponse<?> httpResponse) {
        super(message);
        this.status = status;
        this.errorCode = errorCode;
        this.errors = errors;
        this.httpResponse = httpResponse;
    }

    @Override
    public boolean canBeRetried() {
        return this.httpResponse == null || this.httpResponse.statusCode() >= 500 || this.httpResponse.statusCode() == 429;
    }

    @Override
    public List<String> getErrors() {
        return this.errors;
    }

    @Override
    public HttpResponse<?> getHttpResponse() {
        return this.httpResponse;
    }

    @Override
    public long getErrorCode() {
        return this.errorCode;
    }

    public String getStatus() {
        return this.status;
    }

    @Override
    public String toString() {
        return "PagerDutyRequestException{status='" + this.status + "', errorCode=" + this.errorCode + ", errors=" + this.errors + ", httpResponse=" + this.httpResponse + "}";
    }

    public static Builder build(HttpResponse<?> response) {
        return new PagerDutyRequestExceptionBuilder(response);
    }

    private static final class PagerDutyRequestExceptionBuilder
    implements Builder {
        private final HttpResponse<?> response;
        private String status;
        private String message;
        private long errorCode;
        private List<String> errors;

        private PagerDutyRequestExceptionBuilder(HttpResponse<?> response) {
            this.response = response;
        }

        @Override
        public PagerDutyRequestException create() {
            if (this.errors == null) {
                this.errors = List.of();
            } else if (this.errors.size() > 1) {
                this.errors = Collections.unmodifiableList(this.errors);
            }
            return new PagerDutyRequestException(this.status, this.message, this.errorCode, this.errors, this.response);
        }

        @Override
        public Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public Builder message(String message) {
            this.message = message;
            return this;
        }

        @Override
        public Builder errorCode(long errorCode) {
            this.errorCode = errorCode;
            return this;
        }

        @Override
        public Builder error(String error) {
            if (this.errors == null) {
                this.errors = List.of(error);
                return this;
            }
            if (this.errors.size() == 1) {
                this.errors = new ArrayList<String>(this.errors);
            }
            this.errors.add(error);
            return this;
        }
    }

    public static interface Builder {
        public PagerDutyRequestException create();

        public Builder status(String var1);

        public Builder message(String var1);

        public Builder errorCode(long var1);

        public Builder error(String var1);
    }
}

