/*
 * Decompiled with CFR 0.152.
 */
package systems.comodal.pagerduty.event.client;

import java.net.URI;
import java.net.http.HttpClient;
import java.util.Objects;
import java.util.ServiceLoader;
import systems.comodal.pagerduty.event.client.PagerDutyEventClient;
import systems.comodal.pagerduty.event.client.PagerDutyHttpEventClient;
import systems.comodal.pagerduty.event.data.adapters.PagerDutyEventAdapter;
import systems.comodal.pagerduty.event.data.adapters.PagerDutyEventAdapterFactory;

final class PagerDutyEventClientBuilder
implements PagerDutyEventClient.Builder {
    private String defaultClientName;
    private String defaultClientUrl;
    private String defaultRoutingKey;
    private String authToken;
    private String pagerDutyUri = "https://events.pagerduty.com";
    private HttpClient httpClient;
    private PagerDutyEventAdapter responseAdapter;

    PagerDutyEventClientBuilder() {
    }

    @Override
    public PagerDutyEventClient create() {
        String authHeader = "Token token=" + Objects.requireNonNull(this.authToken, "Auth token is required.");
        URI pageDutyEventsUri = URI.create(this.pagerDutyUri).resolve("/v2/enqueue");
        return new PagerDutyHttpEventClient(this.defaultClientName, this.defaultClientUrl, this.defaultRoutingKey, authHeader, pageDutyEventsUri, this.httpClient == null ? HttpClient.newBuilder().version(HttpClient.Version.HTTP_2).build() : this.httpClient, this.responseAdapter == null ? ServiceLoader.load(PagerDutyEventAdapterFactory.class).findFirst().orElseThrow().create() : this.responseAdapter);
    }

    @Override
    public PagerDutyEventClient.Builder defaultClientName(String defaultClientName) {
        this.defaultClientName = defaultClientName;
        return this;
    }

    @Override
    public PagerDutyEventClient.Builder defaultClientUrl(String defaultClientUrl) {
        this.defaultClientUrl = defaultClientUrl;
        return this;
    }

    @Override
    public PagerDutyEventClient.Builder defaultRoutingKey(String defaultRoutingKey) {
        this.defaultRoutingKey = defaultRoutingKey;
        return this;
    }

    @Override
    public PagerDutyEventClient.Builder authToken(String authToken) {
        this.authToken = authToken;
        return this;
    }

    @Override
    public PagerDutyEventClient.Builder pagerDutyUri(String pagerDutyUri) {
        this.pagerDutyUri = pagerDutyUri;
        return this;
    }

    @Override
    public PagerDutyEventClient.Builder httpClient(HttpClient httpClient) {
        this.httpClient = httpClient;
        return this;
    }

    @Override
    public PagerDutyEventClient.Builder responseAdapter(PagerDutyEventAdapter responseAdapter) {
        this.responseAdapter = responseAdapter;
        return this;
    }

    @Override
    public String getDefaultClientName() {
        return this.defaultClientName;
    }

    @Override
    public String getDefaultClientUrl() {
        return this.defaultClientUrl;
    }

    @Override
    public String getDefaultRoutingKey() {
        return this.defaultRoutingKey;
    }

    @Override
    public String getAuthToken() {
        return this.authToken;
    }

    @Override
    public String getPagerDutyUri() {
        return this.pagerDutyUri;
    }

    @Override
    public HttpClient getHttpClient() {
        return this.httpClient;
    }

    @Override
    public PagerDutyEventAdapter getResponseAdapter() {
        return this.responseAdapter;
    }
}

