/*
 * Decompiled with CFR 0.152.
 */
package systems.comodal.pagerduty.event.data;

import java.io.Serializable;
import java.time.ZonedDateTime;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import systems.comodal.pagerduty.event.data.PagerDutyEventPayload;
import systems.comodal.pagerduty.event.data.PagerDutyImageRef;
import systems.comodal.pagerduty.event.data.PagerDutyLinkRef;
import systems.comodal.pagerduty.event.data.PagerDutySeverity;

final class PagerDutyEventPayloadVal
implements PagerDutyEventPayload {
    private final String dedupKey;
    private final String summary;
    private final String source;
    private final PagerDutySeverity severity;
    private final ZonedDateTime timestamp;
    private final String component;
    private final String group;
    private final String type;
    private final Map<String, Object> customDetails;
    private final List<PagerDutyLinkRef> links;
    private final List<PagerDutyImageRef> images;

    PagerDutyEventPayloadVal(String dedupKey, String summary, String source, PagerDutySeverity severity, ZonedDateTime timestamp, String component, String group, String type, Map<String, Object> customDetails, List<PagerDutyLinkRef> links, List<PagerDutyImageRef> images) {
        this.dedupKey = dedupKey;
        this.summary = summary;
        this.source = source;
        this.severity = severity;
        this.timestamp = timestamp;
        this.component = component;
        this.group = group;
        this.type = type;
        this.customDetails = customDetails;
        this.links = links;
        this.images = images;
    }

    @Override
    public String getDedupKey() {
        return this.dedupKey;
    }

    @Override
    public String getSummary() {
        return this.summary;
    }

    @Override
    public String getSource() {
        return this.source;
    }

    @Override
    public PagerDutySeverity getSeverity() {
        return this.severity;
    }

    @Override
    public ZonedDateTime getTimestamp() {
        return this.timestamp;
    }

    @Override
    public String getComponent() {
        return this.component;
    }

    @Override
    public String getGroup() {
        return this.group;
    }

    @Override
    public String getType() {
        return this.type;
    }

    @Override
    public Map<String, Object> getCustomDetails() {
        return this.customDetails;
    }

    @Override
    public List<PagerDutyLinkRef> getLinks() {
        return this.links;
    }

    @Override
    public List<PagerDutyImageRef> getImages() {
        return this.images;
    }

    @Override
    public String getPayloadJson() {
        return "{\"summary\":\"" + this.summary + "\",\"source\":\"" + this.source + "\",\"severity\":\"" + this.severity + "\",\"timestamp\":\"" + this.timestamp + (Serializable)(this.component == null ? Character.valueOf('\"') : "\",\"component\":\"" + this.component + "\"") + (String)(this.group == null ? "" : ",\"group\":\"" + this.group + "\"") + (String)(this.type == null ? "" : ",\"class\":\"" + this.type + "\"") + (String)(this.customDetails.isEmpty() ? "" : ",\"custom_details\":" + PagerDutyEventPayloadVal.toJson(this.customDetails)) + "}";
    }

    static String toJson(Map<String, Object> object) {
        return object.entrySet().stream().map(entry -> {
            Object val = entry.getValue();
            if (val instanceof Number) {
                return "\"" + (String)entry.getKey() + "\":" + val;
            }
            return "\"" + (String)entry.getKey() + "\":\"" + val + "\"";
        }).collect(Collectors.joining(",", "{", "}"));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PagerDutyEventPayloadVal that = (PagerDutyEventPayloadVal)o;
        return Objects.equals(this.dedupKey, that.dedupKey) && Objects.equals(this.summary, that.summary) && Objects.equals(this.source, that.source) && this.severity == that.severity && Objects.equals(this.timestamp, that.timestamp) && Objects.equals(this.component, that.component) && Objects.equals(this.group, that.group) && Objects.equals(this.type, that.type) && Objects.equals(this.customDetails, that.customDetails);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.dedupKey, this.summary, this.source, this.severity, this.timestamp, this.component, this.group, this.type, this.customDetails});
    }

    public String toString() {
        return this.getPayloadJson();
    }
}

