/*
 * Decompiled with CFR 0.152.
 */
package systems.comodal.pagerduty.event.data;

import java.time.ZonedDateTime;
import java.util.List;
import java.util.Map;
import systems.comodal.pagerduty.event.data.PagerDutyEventPayloadBuilder;
import systems.comodal.pagerduty.event.data.PagerDutyImageRef;
import systems.comodal.pagerduty.event.data.PagerDutyLinkRef;
import systems.comodal.pagerduty.event.data.PagerDutySeverity;

public interface PagerDutyEventPayload {
    public static Builder build() {
        return new PagerDutyEventPayloadBuilder();
    }

    public static Builder build(PagerDutyEventPayload prototype) {
        return prototype == null ? PagerDutyEventPayload.build() : new PagerDutyEventPayloadBuilder(prototype);
    }

    public String getDedupKey();

    public String getSummary();

    public String getSource();

    public PagerDutySeverity getSeverity();

    public ZonedDateTime getTimestamp();

    public String getComponent();

    public String getGroup();

    public String getType();

    public Map<String, Object> getCustomDetails();

    public List<PagerDutyLinkRef> getLinks();

    public List<PagerDutyImageRef> getImages();

    public String getPayloadJson();

    public static interface Builder
    extends PagerDutyEventPayload {
        public PagerDutyEventPayload create();

        public Builder dedupKey(String var1);

        public Builder summary(String var1);

        public Builder source(String var1);

        public Builder severity(PagerDutySeverity var1);

        public Builder timestamp(ZonedDateTime var1);

        public Builder component(String var1);

        public Builder group(String var1);

        public Builder type(String var1);

        public Builder customDetails(String var1, String var2);

        public Builder customDetails(String var1, Number var2);

        public Builder link(PagerDutyLinkRef var1);

        public Builder image(PagerDutyImageRef var1);
    }
}

