/*
 * Decompiled with CFR 0.152.
 */
package systems.comodal.pagerduty.event.service;

import java.time.Duration;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.function.LongUnaryOperator;
import systems.comodal.pagerduty.event.client.PagerDutyEventClient;
import systems.comodal.pagerduty.event.data.PagerDutyEventPayload;
import systems.comodal.pagerduty.event.data.PagerDutyEventResponse;
import systems.comodal.pagerduty.event.service.PagerDutyService;
import systems.comodal.pagerduty.exceptions.PagerDutyClientException;

final class PagerDutyServiceVal
implements PagerDutyService {
    private static final System.Logger log = System.getLogger(PagerDutyService.class.getSimpleName());
    private final PagerDutyEventClient client;
    private final PagerDutyEventPayload eventPrototype;

    PagerDutyServiceVal(PagerDutyEventClient client, PagerDutyEventPayload eventPrototype) {
        this.client = client;
        this.eventPrototype = eventPrototype;
    }

    @Override
    public PagerDutyEventClient getClient() {
        return this.client;
    }

    @Override
    public PagerDutyEventPayload getEventPrototype() {
        return this.eventPrototype;
    }

    @Override
    public CompletableFuture<PagerDutyEventResponse> resolveEvent(String dedupeKey, long stepDelay, long maxDelay, TimeUnit timeUnit) {
        return dedupeKey == null ? null : this.resolveEvent(dedupeKey, 0, PagerDutyService.createRetryDelayFn(stepDelay, maxDelay), timeUnit);
    }

    @Override
    public CompletableFuture<PagerDutyEventResponse> resolveEvent(String dedupeKey, Duration giveUpAfter, long stepDelay, long maxDelay, TimeUnit timeUnit) {
        if (dedupeKey == null) {
            return null;
        }
        int maxRetries = (int)Math.min(Integer.MAX_VALUE, giveUpAfter.toMillis() / timeUnit.toMillis(stepDelay));
        return this.resolveEvent(dedupeKey, 0, PagerDutyService.createRetryDelayFn(maxRetries, stepDelay, maxDelay), timeUnit);
    }

    @Override
    public CompletableFuture<PagerDutyEventResponse> resolveEvent(String dedupeKey, int maxRetries, long stepDelay, long maxDelay, TimeUnit timeUnit) {
        return dedupeKey == null ? null : this.resolveEvent(dedupeKey, 0, PagerDutyService.createRetryDelayFn(maxRetries, stepDelay, maxDelay), timeUnit);
    }

    @Override
    public CompletableFuture<PagerDutyEventResponse> resolveEvent(String dedupeKey, LongUnaryOperator retryDelayFn, TimeUnit timeUnit) {
        return dedupeKey == null ? null : this.resolveEvent(dedupeKey, 0, retryDelayFn, timeUnit);
    }

    private CompletableFuture<PagerDutyEventResponse> resolveEvent(String dedupeKey, int retry, LongUnaryOperator retryDelayFn, TimeUnit timeUnit) {
        long retryDelay = retryDelayFn.applyAsLong(retry);
        if (retryDelay < 0L) {
            return null;
        }
        CompletableFuture<PagerDutyEventResponse> responseFuture = this.client.resolveEvent(dedupeKey);
        Function<Throwable, CompletableFuture> exceptionally = throwable -> {
            int numFailures = retry + 1;
            log.log(System.Logger.Level.ERROR, String.format("Failed %d time(s), last delay was %d %s, to resolve event with dedupe key '%s'.", new Object[]{numFailures, retryDelay, dedupeKey, timeUnit}), (Throwable)throwable);
            return PagerDutyServiceVal.canBeRetried(throwable) ? this.resolveEvent(dedupeKey, numFailures, retryDelayFn, timeUnit) : null;
        };
        if (retryDelay > 0L) {
            return responseFuture.exceptionallyComposeAsync(exceptionally, CompletableFuture.delayedExecutor(retryDelay, timeUnit));
        }
        return responseFuture.exceptionallyCompose(exceptionally);
    }

    private static boolean canBeRetried(Throwable throwable) {
        if (throwable instanceof PagerDutyClientException && !((PagerDutyClientException)((Object)throwable)).canBeRetried()) {
            return false;
        }
        return !(throwable.getCause() instanceof PagerDutyClientException) || ((PagerDutyClientException)((Object)throwable.getCause())).canBeRetried();
    }

    @Override
    public CompletableFuture<PagerDutyEventResponse> triggerEvent(PagerDutyEventPayload payload, long stepDelay, long maxDelay, TimeUnit timeUnit) {
        return this.triggerEvent(payload, 0, PagerDutyService.createRetryDelayFn(stepDelay, maxDelay), timeUnit);
    }

    @Override
    public CompletableFuture<PagerDutyEventResponse> triggerEvent(PagerDutyEventPayload payload, Duration giveUpAfter, long stepDelay, long maxDelay, TimeUnit timeUnit) {
        int maxRetries = (int)Math.min(Integer.MAX_VALUE, giveUpAfter.toMillis() / timeUnit.toMillis(stepDelay));
        return this.triggerEvent(payload, 0, PagerDutyService.createRetryDelayFn(maxRetries, stepDelay, maxDelay), timeUnit);
    }

    @Override
    public CompletableFuture<PagerDutyEventResponse> triggerEvent(PagerDutyEventPayload payload, int maxRetries, long stepDelay, long maxDelay, TimeUnit timeUnit) {
        return this.triggerEvent(payload, 0, PagerDutyService.createRetryDelayFn(maxRetries, stepDelay, maxDelay), timeUnit);
    }

    @Override
    public CompletableFuture<PagerDutyEventResponse> triggerEvent(PagerDutyEventPayload payload, LongUnaryOperator retryDelayFn, TimeUnit timeUnit) {
        return this.triggerEvent(payload, 0, retryDelayFn, timeUnit);
    }

    private CompletableFuture<PagerDutyEventResponse> triggerEvent(PagerDutyEventPayload payload, int retry, LongUnaryOperator retryDelayFn, TimeUnit timeUnit) {
        long retryDelay = retryDelayFn.applyAsLong(retry);
        if (retryDelay < 0L) {
            return null;
        }
        CompletableFuture<PagerDutyEventResponse> responseFuture = this.client.triggerDefaultRouteEvent(payload);
        Function<Throwable, CompletableFuture> exceptionally = throwable -> {
            int numFailures = retry + 1;
            log.log(System.Logger.Level.ERROR, String.format("Failed %d time(s), last delay was %d %s, to trigger event:%n%s%n", new Object[]{numFailures, retryDelay, payload, timeUnit}), (Throwable)throwable);
            return PagerDutyServiceVal.canBeRetried(throwable) ? this.triggerEvent(payload, numFailures, retryDelayFn, timeUnit) : null;
        };
        if (retryDelay > 0L) {
            return responseFuture.exceptionallyComposeAsync(exceptionally, CompletableFuture.delayedExecutor(retryDelay, timeUnit));
        }
        return responseFuture.exceptionallyCompose(exceptionally);
    }

    public String toString() {
        return "PagerdutyServiceVal{client=" + this.client + ", eventPrototype=" + this.eventPrototype + "}";
    }
}

