/*
 * Decompiled with CFR 0.152.
 */
package systems.comodal.pagerduty.exceptions;

import java.net.http.HttpResponse;
import java.util.ArrayList;
import java.util.List;

public final class PagerDutyRequestException
extends RuntimeException {
    private final String status;
    private final List<String> errors;
    private final HttpResponse<?> httpResponse;

    private PagerDutyRequestException(String status, String message, List<String> errors, HttpResponse<?> httpResponse) {
        super(message);
        this.status = status;
        this.errors = errors;
        this.httpResponse = httpResponse;
    }

    public List<String> getErrors() {
        return this.errors;
    }

    public HttpResponse<?> getHttpResponse() {
        return this.httpResponse;
    }

    public String getStatus() {
        return this.status;
    }

    @Override
    public String toString() {
        return "PagerDutyRequestException{status='" + this.status + "', errors=" + this.errors + ", httpResponse=" + this.httpResponse + "}";
    }

    public static Builder build(HttpResponse<?> response) {
        return new PagerDutyRequestExceptionBuilder(response);
    }

    public static interface Builder {
        public PagerDutyRequestException create();

        public Builder status(String var1);

        public Builder message(String var1);

        public Builder error(String var1);
    }

    private static final class PagerDutyRequestExceptionBuilder
    implements Builder {
        private final HttpResponse<?> response;
        private String status;
        private String message;
        private List<String> errors;

        private PagerDutyRequestExceptionBuilder(HttpResponse<?> response) {
            this.response = response;
        }

        @Override
        public PagerDutyRequestException create() {
            if (this.errors == null) {
                this.errors = List.of();
            } else if (this.errors.size() > 1) {
                this.errors = List.copyOf(this.errors);
            }
            return new PagerDutyRequestException(this.status, this.message, this.errors, this.response);
        }

        @Override
        public Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public Builder message(String message) {
            this.message = message;
            return this;
        }

        @Override
        public Builder error(String error) {
            if (this.errors == null) {
                this.errors = List.of(error);
                return this;
            }
            if (this.errors.size() == 1) {
                this.errors = new ArrayList<String>(this.errors);
            }
            this.errors.add(error);
            return this;
        }
    }
}

