/*
 * Decompiled with CFR 0.152.
 */
package systems.comodal.pagerduty.event.service;

import java.time.Duration;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.function.LongUnaryOperator;
import systems.comodal.pagerduty.event.client.PagerDutyEventClient;
import systems.comodal.pagerduty.event.data.PagerDutyEventPayload;
import systems.comodal.pagerduty.event.data.PagerDutyEventResponse;
import systems.comodal.pagerduty.event.service.PagerDutyService;

final class PagerDutyServiceVal
implements PagerDutyService {
    private static final System.Logger log = System.getLogger(PagerDutyService.class.getSimpleName());
    private final PagerDutyEventClient client;
    private final PagerDutyEventPayload eventPrototype;

    PagerDutyServiceVal(PagerDutyEventClient client, PagerDutyEventPayload eventPrototype) {
        this.client = client;
        this.eventPrototype = eventPrototype;
    }

    @Override
    public PagerDutyEventClient getClient() {
        return this.client;
    }

    @Override
    public PagerDutyEventPayload getEventPrototype() {
        return this.eventPrototype;
    }

    @Override
    public CompletableFuture<PagerDutyEventResponse> resolveEvent(PagerDutyEventResponse triggerResponse, Duration giveUpAfter, long stepDelay, long maxDelay, TimeUnit timeUnit) {
        if (triggerResponse == null) {
            return null;
        }
        int maxRetries = (int)Math.min(Integer.MAX_VALUE, giveUpAfter.toMillis() / timeUnit.toMillis(stepDelay));
        return this.resolveEvent(triggerResponse, 0, PagerDutyService.createRetryDelayFn(maxRetries, stepDelay, maxDelay), timeUnit);
    }

    @Override
    public CompletableFuture<PagerDutyEventResponse> resolveEvent(PagerDutyEventResponse triggerResponse, int maxRetries, long stepDelay, long maxDelay, TimeUnit timeUnit) {
        return triggerResponse == null ? null : this.resolveEvent(triggerResponse, 0, PagerDutyService.createRetryDelayFn(maxRetries, stepDelay, maxDelay), timeUnit);
    }

    @Override
    public CompletableFuture<PagerDutyEventResponse> resolveEvent(PagerDutyEventResponse triggerResponse, LongUnaryOperator retryDelayFn, TimeUnit timeUnit) {
        return triggerResponse == null ? null : this.resolveEvent(triggerResponse, 0, retryDelayFn, timeUnit);
    }

    private CompletableFuture<PagerDutyEventResponse> resolveEvent(PagerDutyEventResponse triggerResponse, int retry, LongUnaryOperator retryDelayFn, TimeUnit timeUnit) {
        long retryDelay = retryDelayFn.applyAsLong(retry);
        if (retryDelay < 0L) {
            return null;
        }
        CompletableFuture<PagerDutyEventResponse> responseFuture = this.client.resolveEvent(triggerResponse.getDedupeKey());
        Function<Throwable, CompletableFuture> exceptionally = throwable -> {
            int numFailures = retry + 1;
            log.log(System.Logger.Level.ERROR, String.format("Failed %d time(s), last delay was %d %s, to resolve event with dedupe key '%s'.", new Object[]{numFailures, retryDelay, triggerResponse.getDedupeKey(), timeUnit}), (Throwable)throwable);
            return this.resolveEvent(triggerResponse, numFailures, retryDelayFn, timeUnit);
        };
        if (retryDelay > 0L) {
            return responseFuture.exceptionallyComposeAsync(exceptionally, CompletableFuture.delayedExecutor(retryDelay, timeUnit));
        }
        return responseFuture.exceptionallyCompose(exceptionally);
    }

    @Override
    public CompletableFuture<PagerDutyEventResponse> triggerEvent(PagerDutyEventPayload payload, Duration giveUpAfter, long stepDelay, long maxDelay, TimeUnit timeUnit) {
        int maxRetries = (int)Math.min(Integer.MAX_VALUE, giveUpAfter.toMillis() / timeUnit.toMillis(stepDelay));
        return this.triggerEvent(payload, 0, PagerDutyService.createRetryDelayFn(maxRetries, stepDelay, maxDelay), timeUnit);
    }

    @Override
    public CompletableFuture<PagerDutyEventResponse> triggerEvent(PagerDutyEventPayload payload, int maxRetries, long stepDelay, long maxDelay, TimeUnit timeUnit) {
        return this.triggerEvent(payload, 0, PagerDutyService.createRetryDelayFn(maxRetries, stepDelay, maxDelay), timeUnit);
    }

    @Override
    public CompletableFuture<PagerDutyEventResponse> triggerEvent(PagerDutyEventPayload payload, LongUnaryOperator retryDelayFn, TimeUnit timeUnit) {
        return this.triggerEvent(payload, 0, retryDelayFn, timeUnit);
    }

    private CompletableFuture<PagerDutyEventResponse> triggerEvent(PagerDutyEventPayload payload, int retry, LongUnaryOperator retryDelayFn, TimeUnit timeUnit) {
        long retryDelay = retryDelayFn.applyAsLong(retry);
        if (retryDelay < 0L) {
            return null;
        }
        CompletableFuture<PagerDutyEventResponse> responseFuture = this.client.triggerDefaultRouteEvent(payload);
        Function<Throwable, CompletableFuture> exceptionally = throwable -> {
            int numFailures = retry + 1;
            log.log(System.Logger.Level.ERROR, String.format("Failed %d time(s), last delay was %d %s, to trigger event:%n%s%n", new Object[]{numFailures, retryDelay, payload, timeUnit}), (Throwable)throwable);
            return this.triggerEvent(payload, numFailures, retryDelayFn, timeUnit);
        };
        if (retryDelay > 0L) {
            return responseFuture.exceptionallyComposeAsync(exceptionally, CompletableFuture.delayedExecutor(retryDelay, timeUnit));
        }
        return responseFuture.exceptionallyCompose(exceptionally);
    }

    public String toString() {
        return "PagerdutyServiceVal{client=" + this.client + ", eventPrototype=" + this.eventPrototype + "}";
    }
}

