/*
 * Decompiled with CFR 0.152.
 */
package systems.comodal.pagerduty.event.service;

import java.time.Duration;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import java.util.function.LongUnaryOperator;
import systems.comodal.pagerduty.event.client.PagerDutyEventClient;
import systems.comodal.pagerduty.event.data.PagerDutyEventPayload;
import systems.comodal.pagerduty.event.data.PagerDutyEventResponse;
import systems.comodal.pagerduty.event.service.PagerdutyServiceBuilder;

public interface PagerdutyService {
    public static Builder build() {
        return new PagerdutyServiceBuilder();
    }

    public static LongUnaryOperator createRetryDelayFn(int maxRetries, long stepDelay, long maxDelay) {
        return numFailures -> numFailures > (long)maxRetries ? Long.MIN_VALUE : Math.min(maxDelay, numFailures * stepDelay);
    }

    public PagerDutyEventClient getClient();

    public PagerDutyEventPayload getEventPrototype();

    public CompletableFuture<PagerDutyEventResponse> resolveEvent(PagerDutyEventResponse var1, Duration var2, long var3, long var5, TimeUnit var7);

    public CompletableFuture<PagerDutyEventResponse> resolveEvent(PagerDutyEventResponse var1, int var2, long var3, long var5, TimeUnit var7);

    public CompletableFuture<PagerDutyEventResponse> resolveEvent(PagerDutyEventResponse var1, LongUnaryOperator var2, TimeUnit var3);

    public CompletableFuture<PagerDutyEventResponse> triggerEvent(PagerDutyEventPayload var1, Duration var2, long var3, long var5, TimeUnit var7);

    public CompletableFuture<PagerDutyEventResponse> triggerEvent(PagerDutyEventPayload var1, int var2, long var3, long var5, TimeUnit var7);

    public CompletableFuture<PagerDutyEventResponse> triggerEvent(PagerDutyEventPayload var1, LongUnaryOperator var2, TimeUnit var3);

    public static interface Builder {
        public PagerdutyService create();

        public Builder clientName(PagerDutyEventClient var1);

        public Builder eventPrototype(PagerDutyEventPayload var1);
    }
}

