/*
 * Decompiled with CFR 0.152.
 */
package systems.comodal.pagerduty.event.client;

import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.nio.charset.StandardCharsets;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import systems.comodal.pagerduty.event.client.PagerDutyEventClient;
import systems.comodal.pagerduty.event.data.PagerDutyEventPayload;
import systems.comodal.pagerduty.event.data.PagerDutyEventResponse;
import systems.comodal.pagerduty.event.data.PagerDutyImageRef;
import systems.comodal.pagerduty.event.data.PagerDutyLinkRef;
import systems.comodal.pagerduty.event.data.adapters.PagerDutyEventAdapter;

final class PagerDutyHttpEventClient
implements PagerDutyEventClient {
    private final String defaultClientName;
    private final String defaultClientUrl;
    private final String defaultRoutingKey;
    private final String authorizationHeader;
    private final URI eventUri;
    private final HttpClient httpClient;
    private final PagerDutyEventAdapter adapter;

    PagerDutyHttpEventClient(String defaultClientName, String defaultClientUrl, String defaultRoutingKey, String authorizationHeader, URI eventUri, HttpClient httpClient, PagerDutyEventAdapter adapter) {
        this.defaultClientName = defaultClientName;
        this.defaultClientUrl = defaultClientUrl;
        this.defaultRoutingKey = defaultRoutingKey;
        this.authorizationHeader = authorizationHeader;
        this.eventUri = eventUri;
        this.httpClient = httpClient;
        this.adapter = adapter;
    }

    @Override
    public String getDefaultClientName() {
        return this.defaultClientName;
    }

    @Override
    public String getDefaultClientUrl() {
        return this.defaultClientUrl;
    }

    @Override
    public String getDefaultRoutingKey() {
        return this.defaultRoutingKey;
    }

    @Override
    public CompletableFuture<PagerDutyEventResponse> acknowledgeEvent(String routingKey, String dedupeKey) {
        return this.eventAction(routingKey, dedupeKey, "\",\"event_action\":\"acknowledge\"}");
    }

    @Override
    public CompletableFuture<PagerDutyEventResponse> resolveEvent(String routingKey, String dedupeKey) {
        return this.eventAction(routingKey, dedupeKey, "\",\"event_action\":\"resolve\"}");
    }

    private CompletableFuture<PagerDutyEventResponse> eventAction(String routingKey, String dedupeKey, String actionBody) {
        Objects.requireNonNull(routingKey, "Routing key is a required field.");
        Objects.requireNonNull(dedupeKey, "De-duplication key is a required field.");
        String json = "{\"routing_key\":\"" + routingKey + "\",\"dedup_key\":\"" + dedupeKey + actionBody;
        return this.createAndSendRequest(json);
    }

    @Override
    public CompletableFuture<PagerDutyEventResponse> triggerEvent(String clientName, String clientUrl, String routingKey, String dedupeKey, PagerDutyEventPayload payload) {
        Objects.requireNonNull(routingKey, "Routing key is a required field.");
        String payloadJson = payload.getPayloadJson();
        String imagesJson = payload.getImages().isEmpty() ? "" : payload.getImages().stream().map(PagerDutyImageRef::toJson).collect(Collectors.joining(",", ",\"images\":[", "]"));
        String linksJson = payload.getLinks().isEmpty() ? "" : payload.getLinks().stream().map(PagerDutyLinkRef::toJson).collect(Collectors.joining(",", ",\"links\":[", "]"));
        String json = "{\"event_action\":\"trigger\",\"payload\":" + payloadJson + ",\"routing_key\":\"" + routingKey + "\"" + (String)(dedupeKey == null ? "" : ",\"dedup_key\":\"" + dedupeKey + "\"") + ",\"client\":\"" + clientName + "\"" + (String)(clientUrl == null ? "" : ",\"client_url\":\"" + clientUrl + "\"") + imagesJson + linksJson + "}";
        return this.createAndSendRequest(json);
    }

    private HttpRequest createRequest(String jsonBody) {
        return HttpRequest.newBuilder(this.eventUri).headers("Authorization", this.authorizationHeader, "Accept", "application/vnd.pagerduty+json;version=2", "Content-Type", "application/json").POST(HttpRequest.BodyPublishers.ofString(jsonBody, StandardCharsets.UTF_8)).build();
    }

    private CompletableFuture<PagerDutyEventResponse> createAndSendRequest(String jsonBody) {
        return this.httpClient.sendAsync(this.createRequest(jsonBody), HttpResponse.BodyHandlers.ofInputStream()).thenApplyAsync(this.adapter::adaptResponse);
    }

    public String toString() {
        return "PagerDutyHttpEventClient{defaultClientName='" + this.defaultClientName + "', defaultClientUrl='" + this.defaultClientUrl + "', defaultRoutingKey='" + this.defaultRoutingKey + "', eventUri=" + this.eventUri + "}";
    }
}

