/*
 * Decompiled with CFR 0.152.
 */
package systems.comodal.pagerduty.event.client;

import java.net.http.HttpClient;
import java.util.concurrent.CompletableFuture;
import systems.comodal.pagerduty.event.client.PagerDutyEventClientBuilder;
import systems.comodal.pagerduty.event.data.PagerDutyEventPayload;
import systems.comodal.pagerduty.event.data.PagerDutyEventResponse;
import systems.comodal.pagerduty.event.data.adapters.PagerDutyEventAdapter;

public interface PagerDutyEventClient {
    public static Builder build() {
        return new PagerDutyEventClientBuilder();
    }

    public String getDefaultClientName();

    public String getDefaultClientUrl();

    public String getDefaultRoutingKey();

    default public CompletableFuture<PagerDutyEventResponse> acknowledgeEvent(String dedupeKey) {
        return this.acknowledgeEvent(this.getDefaultRoutingKey(), dedupeKey);
    }

    public CompletableFuture<PagerDutyEventResponse> acknowledgeEvent(String var1, String var2);

    default public CompletableFuture<PagerDutyEventResponse> resolveEvent(String dedupeKey) {
        return this.resolveEvent(this.getDefaultRoutingKey(), dedupeKey);
    }

    public CompletableFuture<PagerDutyEventResponse> resolveEvent(String var1, String var2);

    default public CompletableFuture<PagerDutyEventResponse> triggerDefaultRouteEvent(PagerDutyEventPayload payload) {
        return this.triggerEvent(this.getDefaultRoutingKey(), null, payload);
    }

    default public CompletableFuture<PagerDutyEventResponse> triggerDefaultRouteEvent(String dedupeKey, PagerDutyEventPayload payload) {
        return this.triggerEvent(this.getDefaultRoutingKey(), dedupeKey, payload);
    }

    default public CompletableFuture<PagerDutyEventResponse> triggerEvent(String routingKey, PagerDutyEventPayload payload) {
        return this.triggerEvent(routingKey, null, payload);
    }

    default public CompletableFuture<PagerDutyEventResponse> triggerEvent(String routingKey, String dedupeKey, PagerDutyEventPayload payload) {
        return this.triggerEvent(this.getDefaultClientName(), this.getDefaultClientUrl(), routingKey, dedupeKey, payload);
    }

    public CompletableFuture<PagerDutyEventResponse> triggerEvent(String var1, String var2, String var3, String var4, PagerDutyEventPayload var5);

    public static interface Builder {
        public PagerDutyEventClient create();

        public Builder defaultClientName(String var1);

        public Builder defaultClientUrl(String var1);

        public Builder defaultRoutingKey(String var1);

        public Builder authToken(String var1);

        public Builder pagerDutyUri(String var1);

        public Builder httpClient(HttpClient var1);

        public Builder responseAdapter(PagerDutyEventAdapter var1);

        public String getDefaultClientName();

        public String getDefaultClientUrl();

        public String getDefaultRoutingKey();

        public String getAuthToken();

        public String getPagerDutyUri();

        public HttpClient getHttpClient();

        public PagerDutyEventAdapter getResponseAdapter();
    }
}

