/*
 * Decompiled with CFR 0.152.
 */
package systems.comodal.pagerduty.event.client;

import java.util.concurrent.CompletableFuture;
import systems.comodal.pagerduty.event.data.PagerDutyEventPayload;
import systems.comodal.pagerduty.event.data.PagerDutyEventResponse;

public interface PagerDutyEventClient {
    public String getClientName();

    public String getClientUrl();

    public String getDefaultRoutingKey();

    default public CompletableFuture<PagerDutyEventResponse> acknowledgeEvent(String dedupeKey) {
        return this.acknowledgeEvent(this.getDefaultRoutingKey(), dedupeKey);
    }

    public CompletableFuture<PagerDutyEventResponse> acknowledgeEvent(String var1, String var2);

    default public CompletableFuture<PagerDutyEventResponse> resolveEvent(String dedupeKey) {
        return this.resolveEvent(this.getDefaultRoutingKey(), dedupeKey);
    }

    public CompletableFuture<PagerDutyEventResponse> resolveEvent(String var1, String var2);

    default public CompletableFuture<PagerDutyEventResponse> triggerDefaultRouteEvent(PagerDutyEventPayload payload) {
        return this.triggerEvent(this.getDefaultRoutingKey(), null, payload);
    }

    default public CompletableFuture<PagerDutyEventResponse> triggerDefaultRouteEvent(String dedupeKey, PagerDutyEventPayload payload) {
        return this.triggerEvent(this.getDefaultRoutingKey(), dedupeKey, payload);
    }

    default public CompletableFuture<PagerDutyEventResponse> triggerEvent(String routingKey, PagerDutyEventPayload payload) {
        return this.triggerEvent(routingKey, null, payload);
    }

    default public CompletableFuture<PagerDutyEventResponse> triggerEvent(String routingKey, String dedupeKey, PagerDutyEventPayload payload) {
        return this.triggerEvent(this.getClientName(), this.getClientUrl(), routingKey, dedupeKey, payload);
    }

    public CompletableFuture<PagerDutyEventResponse> triggerEvent(String var1, String var2, String var3, String var4, PagerDutyEventPayload var5);
}

