/*
 * Decompiled with CFR 0.152.
 */
package systems.comodal.pagerduty.event.data.adapters;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.http.HttpResponse;
import java.nio.charset.StandardCharsets;
import java.util.concurrent.ConcurrentLinkedQueue;
import systems.comodal.jsoniter.JsonException;
import systems.comodal.jsoniter.JsonIterator;
import systems.comodal.pagerduty.config.PagerDutySysProp;
import systems.comodal.pagerduty.event.data.PagerDutyEventResponse;
import systems.comodal.pagerduty.event.data.adapters.PagerDutyEventAdapter;
import systems.comodal.pagerduty.exceptions.PagerDutyParseException;
import systems.comodal.pagerduty.exceptions.PagerDutyRequestException;

final class JsonIteratorPagerDutyEventAdapter
implements PagerDutyEventAdapter {
    static final JsonIteratorPagerDutyEventAdapter INSTANCE = new JsonIteratorPagerDutyEventAdapter();
    private static final boolean DEBUG = PagerDutySysProp.DEBUG.getBooleanProperty().orElse(Boolean.FALSE);
    private static final ConcurrentLinkedQueue<JsonIterator> JSON_ITERATOR_POOL = new ConcurrentLinkedQueue();

    private JsonIteratorPagerDutyEventAdapter() {
    }

    private static JsonIterator createInputStreamJsonIterator(InputStream inputStream) throws IOException {
        if (DEBUG) {
            byte[] responseBytes = JsonIteratorPagerDutyEventAdapter.slowRead(inputStream);
            System.out.println(new String(responseBytes, StandardCharsets.UTF_8));
            return JsonIterator.parse((byte[])responseBytes);
        }
        JsonIterator jsonIterator = JSON_ITERATOR_POOL.poll();
        return jsonIterator == null ? JsonIterator.parse((InputStream)inputStream, (int)2048) : jsonIterator.reset(inputStream);
    }

    private static byte[] slowRead(InputStream inputStream) throws IOException {
        try (ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();){
            inputStream.transferTo(byteArrayOutputStream);
            byte[] byArray = byteArrayOutputStream.toByteArray();
            return byArray;
        }
    }

    private static void returnJsonIterator(JsonIterator jsonIterator) {
        if (!DEBUG) {
            JSON_ITERATOR_POOL.add(jsonIterator);
        }
    }

    private static JsonIterator createInputStreamJsonIterator(HttpResponse<InputStream> response) throws IOException {
        return JsonIteratorPagerDutyEventAdapter.createInputStreamJsonIterator(response.body());
    }

    @Override
    public RuntimeException errorResponse(HttpResponse<InputStream> response) {
        try {
            JsonIterator jsonIterator = JsonIteratorPagerDutyEventAdapter.createInputStreamJsonIterator(response);
            try {
                try {
                    try {
                        PagerDutyRequestException.Builder exception = PagerDutyRequestException.build(response);
                        if (response.statusCode() == 429) {
                            throw exception.message("Too many requests").create();
                        }
                        throw this.adaptException(exception, jsonIterator);
                    }
                    catch (IOException | NullPointerException | JsonException runtimeCause) {
                        throw new PagerDutyParseException(runtimeCause, jsonIterator.currentBuffer());
                    }
                }
                catch (Throwable throwable) {
                    JsonIteratorPagerDutyEventAdapter.returnJsonIterator(jsonIterator);
                    throw throwable;
                }
            }
            catch (Throwable throwable) {
                if (jsonIterator != null) {
                    try {
                        jsonIterator.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
        }
        catch (IOException ioEx) {
            throw new PagerDutyParseException(ioEx);
        }
        catch (ArrayIndexOutOfBoundsException | NullPointerException | JsonException runtimeCause) {
            throw new PagerDutyParseException("Failed to adapt error response.", runtimeCause);
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive exception aggregation
     */
    @Override
    public PagerDutyEventResponse adaptResponse(HttpResponse<InputStream> response) {
        this.verifyHttpResponseCode(response);
        try (JsonIterator jsonIterator = JsonIteratorPagerDutyEventAdapter.createInputStreamJsonIterator(response);){
            try {
                PagerDutyEventResponse pagerDutyEventResponse = this.adaptResponse(jsonIterator);
                return pagerDutyEventResponse;
            }
            catch (IOException | NullPointerException | JsonException runtimeCause) {
                throw new PagerDutyParseException(runtimeCause, jsonIterator.currentBuffer());
            }
            finally {
                JsonIteratorPagerDutyEventAdapter.returnJsonIterator(jsonIterator);
            }
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
        catch (IOException ioEx) {
            throw new PagerDutyParseException(ioEx);
        }
        catch (ArrayIndexOutOfBoundsException | NullPointerException | JsonException runtimeCause) {
            throw new PagerDutyParseException("Failed to adapt event response.", runtimeCause);
        }
    }

    private PagerDutyEventResponse adaptResponse(JsonIterator jsonIterator) throws IOException {
        PagerDutyEventResponse.Builder response = PagerDutyEventResponse.build();
        String field = jsonIterator.readObject();
        while (field != null) {
            switch (field) {
                case "status": {
                    response.status(jsonIterator.readString());
                    break;
                }
                case "message": {
                    response.message(jsonIterator.readString());
                    break;
                }
                case "dedup_key": {
                    response.dedupeKey(jsonIterator.readString());
                    break;
                }
                default: {
                    throw PagerDutyParseException.unhandledField("event response", field, jsonIterator.currentBuffer());
                }
            }
            field = jsonIterator.readObject();
        }
        return response.create();
    }

    private PagerDutyRequestException adaptException(PagerDutyRequestException.Builder exception, JsonIterator jsonIterator) throws IOException {
        String field = jsonIterator.readObject();
        while (field != null) {
            switch (field) {
                case "status": {
                    exception.status(jsonIterator.readString());
                    break;
                }
                case "message": {
                    exception.message(jsonIterator.readString());
                    break;
                }
                case "errors": {
                    while (jsonIterator.readArray()) {
                        exception.error(jsonIterator.readString());
                    }
                    break;
                }
                default: {
                    throw PagerDutyParseException.unhandledField("error", field, jsonIterator.currentBuffer());
                }
            }
            field = jsonIterator.readObject();
        }
        return exception.create();
    }
}

