/*
 * Decompiled with CFR 0.152.
 */
package systems.comodal.pagerduty.event.data;

import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import systems.comodal.pagerduty.event.data.PagerDutyEventPayload;
import systems.comodal.pagerduty.event.data.PagerDutyImageRef;
import systems.comodal.pagerduty.event.data.PagerDutyLinkRef;
import systems.comodal.pagerduty.event.data.PagerDutySeverity;

final class PagerDutyEventPayloadVal
implements PagerDutyEventPayload {
    private final String summary;
    private final String source;
    private final PagerDutySeverity severity;
    private final ZonedDateTime timestamp;
    private final String component;
    private final String group;
    private final String type;
    private final Map<String, Object> customDetails;
    private final List<PagerDutyLinkRef> links;
    private final List<PagerDutyImageRef> images;

    private PagerDutyEventPayloadVal(String summary, String source, PagerDutySeverity severity, ZonedDateTime timestamp, String component, String group, String type, Map<String, Object> customDetails, List<PagerDutyLinkRef> links, List<PagerDutyImageRef> images) {
        this.summary = summary;
        this.source = source;
        this.severity = severity;
        this.timestamp = timestamp;
        this.component = component;
        this.group = group;
        this.type = type;
        this.customDetails = customDetails;
        this.links = links;
        this.images = images;
    }

    @Override
    public String getSummary() {
        return this.summary;
    }

    @Override
    public String getSource() {
        return this.source;
    }

    @Override
    public PagerDutySeverity getSeverity() {
        return this.severity;
    }

    @Override
    public ZonedDateTime getTimestamp() {
        return this.timestamp;
    }

    @Override
    public String getComponent() {
        return this.component;
    }

    @Override
    public String getGroup() {
        return this.group;
    }

    @Override
    public String getType() {
        return this.type;
    }

    @Override
    public Map<String, Object> getCustomDetails() {
        return this.customDetails;
    }

    @Override
    public List<PagerDutyLinkRef> getLinks() {
        return this.links;
    }

    @Override
    public List<PagerDutyImageRef> getImages() {
        return this.images;
    }

    @Override
    public String getPayloadJson() {
        return "{\"summary\":\"" + this.summary + "\",\"source\":\"" + this.source + "\",\"severity\":\"" + this.severity + "\",\"timestamp\":\"" + this.timestamp + (String)(this.component == null ? "\"" : "\",\"component\":\"" + this.component + "\"") + (String)(this.group == null ? "" : ",\"group\":\"" + this.group + "\"") + (String)(this.type == null ? "" : ",\"class\":\"" + this.type + "\"") + (String)(this.customDetails.isEmpty() ? "" : ",\"custom_details\":" + PagerDutyEventPayloadVal.toJson(this.customDetails)) + "}";
    }

    private static String toJson(Map<String, Object> object) {
        return object.entrySet().stream().map(entry -> {
            Object val = entry.getValue();
            if (val instanceof Number) {
                return "\"" + (String)entry.getKey() + "\":" + val;
            }
            return "\"" + (String)entry.getKey() + "\":\"" + val + "\"";
        }).collect(Collectors.joining(",", "{", "}"));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PagerDutyEventPayloadVal that = (PagerDutyEventPayloadVal)o;
        return Objects.equals(this.summary, that.summary) && Objects.equals(this.source, that.source) && this.severity == that.severity && Objects.equals(this.timestamp, that.timestamp) && Objects.equals(this.component, that.component) && Objects.equals(this.group, that.group) && Objects.equals(this.type, that.type) && Objects.equals(this.customDetails, that.customDetails);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.summary, this.source, this.severity, this.timestamp, this.component, this.group, this.type, this.customDetails});
    }

    public String toString() {
        return this.getPayloadJson();
    }

    static final class PagerDutyEventPayloadBuilder
    implements PagerDutyEventPayload.Builder {
        private String summary;
        private String source;
        private PagerDutySeverity severity;
        private ZonedDateTime timestamp;
        private String component;
        private String group;
        private String type;
        private Map<String, Object> customDetails;
        private List<PagerDutyLinkRef> links = List.of();
        private List<PagerDutyImageRef> images = List.of();

        PagerDutyEventPayloadBuilder() {
        }

        @Override
        public PagerDutyEventPayload create() {
            return new PagerDutyEventPayloadVal(Objects.requireNonNull(this.summary, "Summary is a required payload field."), Objects.requireNonNull(this.source, "Source is a required payload field."), Objects.requireNonNull(this.severity, "Severity is a required payload field."), this.timestamp == null ? ZonedDateTime.now(ZoneOffset.UTC) : this.timestamp, this.component, this.group, this.type, this.getCustomDetails(), this.links, this.images);
        }

        @Override
        public PagerDutyEventPayload.Builder summary(String summary) {
            this.summary = summary;
            return this;
        }

        @Override
        public PagerDutyEventPayload.Builder source(String source) {
            this.source = source;
            return this;
        }

        @Override
        public PagerDutyEventPayload.Builder severity(PagerDutySeverity severity) {
            this.severity = severity;
            return this;
        }

        @Override
        public PagerDutyEventPayload.Builder timestamp(ZonedDateTime timestamp) {
            this.timestamp = timestamp;
            return this;
        }

        @Override
        public PagerDutyEventPayload.Builder component(String component) {
            this.component = component;
            return this;
        }

        @Override
        public PagerDutyEventPayload.Builder group(String group) {
            this.group = group;
            return this;
        }

        @Override
        public PagerDutyEventPayload.Builder type(String type) {
            this.type = type;
            return this;
        }

        private PagerDutyEventPayload.Builder customDetailsObject(String field, Object fieldValue) {
            if (this.customDetails == null) {
                this.customDetails = new LinkedHashMap<String, Object>();
            }
            this.customDetails.put(field, fieldValue);
            return this;
        }

        @Override
        public PagerDutyEventPayload.Builder customDetails(String field, String fieldValue) {
            return this.customDetailsObject(field, fieldValue);
        }

        @Override
        public PagerDutyEventPayload.Builder customDetails(String field, Number fieldValue) {
            return this.customDetailsObject(field, fieldValue);
        }

        @Override
        public PagerDutyEventPayload.Builder link(PagerDutyLinkRef link) {
            if (this.links.isEmpty()) {
                this.links = List.of(link);
                return this;
            }
            if (this.links.size() == 1) {
                this.links = new ArrayList<PagerDutyLinkRef>(this.links);
            }
            this.links.add(link);
            return this;
        }

        @Override
        public PagerDutyEventPayload.Builder image(PagerDutyImageRef image) {
            if (this.images.isEmpty()) {
                this.images = List.of(image);
                return this;
            }
            if (this.images.size() == 1) {
                this.images = new ArrayList<PagerDutyImageRef>(this.images);
            }
            this.images.add(image);
            return this;
        }

        @Override
        public String getSummary() {
            return this.summary;
        }

        @Override
        public String getSource() {
            return this.source;
        }

        @Override
        public PagerDutySeverity getSeverity() {
            return this.severity;
        }

        @Override
        public ZonedDateTime getTimestamp() {
            return this.timestamp;
        }

        @Override
        public String getComponent() {
            return this.component;
        }

        @Override
        public String getGroup() {
            return this.group;
        }

        @Override
        public String getType() {
            return this.type;
        }

        @Override
        public Map<String, Object> getCustomDetails() {
            return this.customDetails == null ? Map.of() : this.customDetails;
        }

        @Override
        public List<PagerDutyLinkRef> getLinks() {
            return this.links;
        }

        @Override
        public List<PagerDutyImageRef> getImages() {
            return this.images;
        }

        @Override
        public String getPayloadJson() {
            return "{\"summary\":\"" + this.summary + "\",\"source\":\"" + this.source + "\",\"severity\":\"" + this.severity + "\",\"timestamp\":\"" + this.timestamp + (String)(this.component == null ? "\"" : "\",\"component\":\"" + this.component + "\"") + (String)(this.group == null ? "" : ",\"group\":\"" + this.group + "\"") + (String)(this.type == null ? "" : ",\"type\":\"" + this.type + "\"") + (String)(this.customDetails == null ? "" : ",\"custom_details\":" + PagerDutyEventPayloadVal.toJson(this.customDetails)) + "}";
        }

        public String toString() {
            return this.getPayloadJson();
        }
    }
}

