/*
 * Decompiled with CFR 0.152.
 */
package systems.comodal.pagerduty.event.client;

import java.io.Serializable;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.nio.charset.StandardCharsets;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import systems.comodal.pagerduty.client.PagerDutyHttpClientProvider;
import systems.comodal.pagerduty.config.PagerDutySysProp;
import systems.comodal.pagerduty.event.client.PagerDutyEventClient;
import systems.comodal.pagerduty.event.data.PagerDutyEventPayload;
import systems.comodal.pagerduty.event.data.PagerDutyEventResponse;
import systems.comodal.pagerduty.event.data.PagerDutyImageRef;
import systems.comodal.pagerduty.event.data.PagerDutyLinkRef;
import systems.comodal.pagerduty.event.data.adapters.PagerDutyEventAdapter;
import systems.comodal.pagerduty.event.data.adapters.PagerDutyEventAdapterFactory;

final class PagerDutyHttpEventClient
implements PagerDutyEventClient {
    private final String clientName;
    private final String clientUrl;
    private final String defaultRoutingKey;
    private final String authTokenHeaderVal;
    private final URI eventUriPath;
    private final HttpClient httpClient;
    private final PagerDutyEventAdapter adapter;

    PagerDutyHttpEventClient(String clientName) {
        this.clientName = clientName;
        this.clientUrl = PagerDutySysProp.PAGER_DUTY_EVENT_CLIENT_URL.getStringProperty(clientName).orElse(null);
        this.defaultRoutingKey = PagerDutySysProp.PAGER_DUTY_EVENT_CLIENT_ROUTING_KEY.getStringProperty(clientName).orElse(null);
        this.authTokenHeaderVal = "Token token=" + PagerDutySysProp.PAGER_DUTY_EVENT_CLIENT_AUTH_TOKEN.getMandatoryStringProperty(clientName);
        this.httpClient = PagerDutyHttpClientProvider.load();
        this.adapter = PagerDutyEventAdapterFactory.load();
        URI endpoint = URI.create(PagerDutySysProp.PAGER_DUTY_EVENT_CLIENT_ENDPOINT.getStringProperty(clientName).orElse("https://events.pagerduty.com"));
        this.eventUriPath = endpoint.resolve("/v2/enqueue");
    }

    @Override
    public String getClientName() {
        return this.clientName;
    }

    @Override
    public String getClientUrl() {
        return this.clientUrl;
    }

    @Override
    public String getDefaultRoutingKey() {
        return this.defaultRoutingKey;
    }

    @Override
    public CompletableFuture<PagerDutyEventResponse> acknowledgeEvent(String routingKey, String dedupeKey) {
        return this.eventAction(routingKey, dedupeKey, "\",\"event_action\":\"acknowledge\"}");
    }

    @Override
    public CompletableFuture<PagerDutyEventResponse> resolveEvent(String routingKey, String dedupeKey) {
        return this.eventAction(routingKey, dedupeKey, "\",\"event_action\":\"resolve\"}");
    }

    private CompletableFuture<PagerDutyEventResponse> eventAction(String routingKey, String dedupeKey, String actionBody) {
        Objects.requireNonNull(routingKey, "Routing key is a required field.");
        Objects.requireNonNull(dedupeKey, "De-duplication key is a required field.");
        String json = "{\"routing_key\":\"" + routingKey + "\",\"dedup_key\":\"" + dedupeKey + actionBody;
        return this.createAndSendRequest(json);
    }

    @Override
    public CompletableFuture<PagerDutyEventResponse> triggerEvent(String clientName, String clientUrl, String routingKey, String dedupeKey, PagerDutyEventPayload payload) {
        Objects.requireNonNull(routingKey, "Routing key is a required field.");
        String payloadJson = payload.getPayloadJson();
        String imagesJson = payload.getImages().isEmpty() ? "" : payload.getImages().stream().map(PagerDutyImageRef::toJson).collect(Collectors.joining(",", ",\"images\":[", "]"));
        String linksJson = payload.getLinks().isEmpty() ? "" : payload.getLinks().stream().map(PagerDutyLinkRef::toJson).collect(Collectors.joining(",", ",\"links\":[", "]"));
        String json = "{\"event_action\":\"trigger\",\"payload\":" + payloadJson + ",\"routing_key\":\"" + routingKey + "\"" + (String)(dedupeKey == null ? "" : ",\"dedup_key\":\"" + dedupeKey + "\"") + ",\"client\":\"" + clientName + "\"" + (String)(clientUrl == null ? "" : ",\"client_url\":\"" + clientUrl + "\"") + imagesJson + linksJson + "}";
        return this.createAndSendRequest(json);
    }

    private HttpRequest createRequest(String jsonBody) {
        return HttpRequest.newBuilder(this.eventUriPath).headers("Authorization", this.authTokenHeaderVal, "Accept", "application/vnd.pagerduty+json;version=2", "Content-Type", "application/json").POST(HttpRequest.BodyPublishers.ofString(jsonBody, StandardCharsets.UTF_8)).build();
    }

    private CompletableFuture<PagerDutyEventResponse> createAndSendRequest(String jsonBody) {
        return this.httpClient.sendAsync(this.createRequest(jsonBody), HttpResponse.BodyHandlers.ofInputStream()).thenApplyAsync(this.adapter::adaptResponse);
    }

    public String toString() {
        return "{\"_class\":\"PagerDutyHttpEventClient\", \"clientName\":" + (String)(this.clientName == null ? "null" : "\"" + this.clientName + "\"") + ", \"clientUrl\":" + (String)(this.clientUrl == null ? "null" : "\"" + this.clientUrl + "\"") + ", \"eventUriPath\":" + (Serializable)(this.eventUriPath == null ? "null" : this.eventUriPath) + "}";
    }
}

