/*
 * Decompiled with CFR 0.152.
 */
package systems.comodal.pagerduty.config;

import java.lang.reflect.InvocationTargetException;
import java.util.Optional;
import java.util.ServiceLoader;
import java.util.function.Predicate;
import java.util.stream.Collectors;

public final class ServiceUtil {
    private ServiceUtil() {
    }

    private static IllegalStateException providerClassNotFoundException(String providerClassName) {
        return new IllegalStateException(String.format("There is no available provider of type %s.", providerClassName));
    }

    private static IllegalStateException providerNotFoundException(ServiceLoader<?> serviceLoader) {
        serviceLoader.reload();
        if (!serviceLoader.iterator().hasNext()) {
            return new IllegalStateException("No Providers found by " + serviceLoader);
        }
        String availableProviders = serviceLoader.stream().map(provider -> provider.type().getName()).collect(Collectors.joining(","));
        return new IllegalStateException("Provider not found by " + serviceLoader + ".\nAvailable:\n" + availableProviders);
    }

    public static <S> S loadService(ServiceLoader<S> serviceLoader, String providerClassName) {
        if (providerClassName == null || providerClassName.isEmpty()) {
            return serviceLoader.findFirst().orElseThrow(() -> ServiceUtil.providerNotFoundException(serviceLoader));
        }
        try {
            Class<?> providerClass = Class.forName(providerClassName);
            Optional<Object> optionalProvider = serviceLoader.stream().filter(serviceProvider -> providerClass.equals(serviceProvider.type())).map(ServiceLoader.Provider::get).findFirst();
            return (S)(optionalProvider.isPresent() ? optionalProvider.orElseThrow() : providerClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]));
        }
        catch (ClassNotFoundException classNotFoundEx) {
            throw ServiceUtil.providerClassNotFoundException(providerClassName);
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw new IllegalStateException(String.format("Desired provider class %s does not have a zero argument public constructor.", providerClassName));
        }
    }

    public static <S> S loadService(ServiceLoader<S> serviceLoader, Predicate<ServiceLoader.Provider<S>> filter) {
        return ServiceUtil.tryLoadService(serviceLoader, filter).orElseThrow(() -> ServiceUtil.providerNotFoundException(serviceLoader));
    }

    static <S> Optional<S> tryLoadService(ServiceLoader<S> serviceLoader, Predicate<ServiceLoader.Provider<S>> filter) {
        return filter == null ? serviceLoader.findFirst() : serviceLoader.stream().filter(filter).map(ServiceLoader.Provider::get).findFirst();
    }
}

