/*
 * Decompiled with CFR 0.152.
 */
package systems.comodal.pagerduty.event.service;

import java.time.Duration;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import java.util.function.LongUnaryOperator;
import systems.comodal.pagerduty.event.client.PagerDutyEventClient;
import systems.comodal.pagerduty.event.data.PagerDutyEventPayload;
import systems.comodal.pagerduty.event.data.PagerDutyEventResponse;
import systems.comodal.pagerduty.event.service.PagerDutyServiceBuilder;

public interface PagerDutyService {
    public static Builder build() {
        return new PagerDutyServiceBuilder();
    }

    public static LongUnaryOperator createRetryDelayFn(long stepDelay, long maxDelay) {
        return numFailures -> Math.min(maxDelay, numFailures * stepDelay);
    }

    public static LongUnaryOperator createRetryDelayFn(int maxRetries, long stepDelay, long maxDelay) {
        return numFailures -> numFailures > (long)maxRetries ? Long.MIN_VALUE : Math.min(maxDelay, numFailures * stepDelay);
    }

    public PagerDutyEventClient getClient();

    public PagerDutyEventPayload getEventPrototype();

    default public CompletableFuture<PagerDutyEventResponse> resolveEvent(PagerDutyEventResponse triggerResponse, long stepDelay, long maxDelay, TimeUnit timeUnit) {
        return triggerResponse == null ? null : this.resolveEvent(triggerResponse.getDedupKey(), stepDelay, maxDelay, timeUnit);
    }

    public CompletableFuture<PagerDutyEventResponse> resolveEvent(String var1, long var2, long var4, TimeUnit var6);

    default public CompletableFuture<PagerDutyEventResponse> resolveEvent(PagerDutyEventResponse triggerResponse, Duration giveUpAfter, long stepDelay, long maxDelay, TimeUnit timeUnit) {
        return triggerResponse == null ? null : this.resolveEvent(triggerResponse.getDedupKey(), giveUpAfter, stepDelay, maxDelay, timeUnit);
    }

    public CompletableFuture<PagerDutyEventResponse> resolveEvent(String var1, Duration var2, long var3, long var5, TimeUnit var7);

    default public CompletableFuture<PagerDutyEventResponse> resolveEvent(PagerDutyEventResponse triggerResponse, int maxRetries, long stepDelay, long maxDelay, TimeUnit timeUnit) {
        return triggerResponse == null ? null : this.resolveEvent(triggerResponse.getDedupKey(), maxRetries, stepDelay, maxDelay, timeUnit);
    }

    public CompletableFuture<PagerDutyEventResponse> resolveEvent(String var1, int var2, long var3, long var5, TimeUnit var7);

    default public CompletableFuture<PagerDutyEventResponse> resolveEvent(PagerDutyEventResponse triggerResponse, LongUnaryOperator retryDelayFn, TimeUnit timeUnit) {
        return triggerResponse == null ? null : this.resolveEvent(triggerResponse.getDedupKey(), retryDelayFn, timeUnit);
    }

    public CompletableFuture<PagerDutyEventResponse> resolveEvent(String var1, LongUnaryOperator var2, TimeUnit var3);

    public CompletableFuture<PagerDutyEventResponse> triggerEvent(PagerDutyEventPayload var1, long var2, long var4, TimeUnit var6);

    public CompletableFuture<PagerDutyEventResponse> triggerEvent(PagerDutyEventPayload var1, Duration var2, long var3, long var5, TimeUnit var7);

    public CompletableFuture<PagerDutyEventResponse> triggerEvent(PagerDutyEventPayload var1, int var2, long var3, long var5, TimeUnit var7);

    public CompletableFuture<PagerDutyEventResponse> triggerEvent(PagerDutyEventPayload var1, LongUnaryOperator var2, TimeUnit var3);

    public static interface Builder {
        public PagerDutyService create();

        public Builder client(PagerDutyEventClient var1);

        public Builder eventPrototype(PagerDutyEventPayload var1);
    }
}

