/*
 * Decompiled with CFR 0.152.
 */
package systems.comodal.pagerduty.event.data.adapters;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.concurrent.ConcurrentLinkedQueue;
import jdk.incubator.http.HttpResponse;
import systems.comodal.jsoniter.JsonException;
import systems.comodal.jsoniter.JsonIterator;
import systems.comodal.pagerduty.config.PagerDutySysProp;
import systems.comodal.pagerduty.event.data.PagerDutyEventResponse;
import systems.comodal.pagerduty.event.data.adapters.PagerDutyEventAdapter;
import systems.comodal.pagerduty.exceptions.PagerDutyParseException;
import systems.comodal.pagerduty.exceptions.PagerDutyRequestException;

final class JsonIteratorPagerDutyEventAdapter
implements PagerDutyEventAdapter {
    static final JsonIteratorPagerDutyEventAdapter INSTANCE = new JsonIteratorPagerDutyEventAdapter();
    private static final boolean DEBUG = PagerDutySysProp.DEBUG.getBooleanProperty().orElse(Boolean.FALSE);
    private static final ConcurrentLinkedQueue<JsonIterator> JSON_ITERATOR_POOL = new ConcurrentLinkedQueue();

    private JsonIteratorPagerDutyEventAdapter() {
    }

    private static JsonIterator createInputStreamJsonIterator(InputStream inputStream) throws IOException {
        if (DEBUG) {
            byte[] responseBytes = JsonIteratorPagerDutyEventAdapter.slowRead(inputStream);
            System.out.println(new String(responseBytes, StandardCharsets.UTF_8));
            return JsonIterator.parse((byte[])responseBytes);
        }
        JsonIterator jsonIterator = JSON_ITERATOR_POOL.poll();
        return jsonIterator == null ? JsonIterator.parse((InputStream)inputStream, (int)2048) : jsonIterator.reset(inputStream);
    }

    private static byte[] slowRead(InputStream inputStream) throws IOException {
        try (ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();){
            inputStream.transferTo(byteArrayOutputStream);
            byte[] byArray = byteArrayOutputStream.toByteArray();
            return byArray;
        }
    }

    private static void returnJsonIterator(JsonIterator jsonIterator) {
        if (!DEBUG) {
            JSON_ITERATOR_POOL.add(jsonIterator);
        }
    }

    private static JsonIterator createInputStreamJsonIterator(HttpResponse<InputStream> response) throws IOException {
        return JsonIteratorPagerDutyEventAdapter.createInputStreamJsonIterator((InputStream)response.body());
    }

    @Override
    public RuntimeException errorResponse(HttpResponse<InputStream> response) {
        try {
            JsonIterator jsonIterator = JsonIteratorPagerDutyEventAdapter.createInputStreamJsonIterator(response);
            Throwable throwable = null;
            try {
                try {
                    try {
                        try {
                            PagerDutyRequestException.Builder exception = PagerDutyRequestException.build(response);
                            if (response.statusCode() == 429) {
                                throw exception.message("Too many requests").create();
                            }
                            throw this.adaptException(exception, jsonIterator);
                        }
                        catch (IOException | NullPointerException | JsonException runtimeCause) {
                            throw new PagerDutyParseException(runtimeCause, jsonIterator.currentBuffer());
                        }
                    }
                    catch (Throwable throwable2) {
                        JsonIteratorPagerDutyEventAdapter.returnJsonIterator(jsonIterator);
                        throw throwable2;
                    }
                }
                catch (Throwable throwable3) {
                    throwable = throwable3;
                    throw throwable3;
                }
            }
            catch (Throwable throwable4) {
                if (jsonIterator != null) {
                    JsonIteratorPagerDutyEventAdapter.$closeResource(throwable, (AutoCloseable)jsonIterator);
                }
                throw throwable4;
            }
        }
        catch (IOException ioEx) {
            throw new PagerDutyParseException(ioEx);
        }
        catch (ArrayIndexOutOfBoundsException | NullPointerException | JsonException runtimeCause) {
            throw new PagerDutyParseException("Failed to adapt error response.", runtimeCause);
        }
    }

    /*
     * Exception decompiling
     */
    @Override
    public PagerDutyEventResponse adaptResponse(HttpResponse<InputStream> response) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private PagerDutyEventResponse adaptResponse(JsonIterator jsonIterator) throws IOException {
        PagerDutyEventResponse.Builder response = PagerDutyEventResponse.build();
        String field = jsonIterator.readObject();
        while (field != null) {
            switch (field) {
                case "status": {
                    response.status(jsonIterator.readString());
                    break;
                }
                case "message": {
                    response.message(jsonIterator.readString());
                    break;
                }
                case "dedup_key": {
                    response.dedupeKey(jsonIterator.readString());
                    break;
                }
                default: {
                    throw PagerDutyParseException.unhandledField("event response", field, jsonIterator.currentBuffer());
                }
            }
            field = jsonIterator.readObject();
        }
        return response.create();
    }

    private PagerDutyRequestException adaptException(PagerDutyRequestException.Builder exception, JsonIterator jsonIterator) throws IOException {
        String field = jsonIterator.readObject();
        while (field != null) {
            switch (field) {
                case "status": {
                    exception.status(jsonIterator.readString());
                    break;
                }
                case "message": {
                    exception.message(jsonIterator.readString());
                    break;
                }
                case "errors": {
                    while (jsonIterator.readArray()) {
                        exception.error(jsonIterator.readString());
                    }
                    break;
                }
                default: {
                    throw PagerDutyParseException.unhandledField("error", field, jsonIterator.currentBuffer());
                }
            }
            field = jsonIterator.readObject();
        }
        return exception.create();
    }
}

