/*
 * Decompiled with CFR 0.152.
 */
package systems.comodal.pagerduty.config;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Optional;
import java.util.OptionalDouble;
import java.util.OptionalInt;
import java.util.OptionalLong;
import java.util.Properties;
import java.util.function.Supplier;

public interface SysProp {
    private static String getBaseDomain() {
        return "systems.comodal.pagerduty";
    }

    public String getPropertyKeyPath();

    public static void loadProps() {
        SysProp.loadProps(SysProp.getBaseDomain() + ".properties_file");
    }

    public static void loadProps(String propFilePathKey) {
        String propFilePathString = System.getProperty(propFilePathKey);
        if (propFilePathString == null) {
            return;
        }
        SysProp.loadProps(Paths.get(propFilePathString, new String[0]));
    }

    public static void loadProps(Path propFilePath) {
        if (!Files.isReadable(propFilePath)) {
            throw new IllegalStateException("Properties file " + propFilePath + " is not readable.");
        }
        Properties propertiesCopy = new Properties(System.getProperties());
        try {
            propertiesCopy.load(Files.newInputStream(propFilePath, new OpenOption[0]));
        }
        catch (IOException ioException) {
            throw new UncheckedIOException(ioException);
        }
        System.setProperties(propertiesCopy);
    }

    public static String formatPath(String path) {
        return path.replace('/', '.');
    }

    public static String formatPath(Path path) {
        return SysProp.formatPath(path.toAbsolutePath().toString());
    }

    default public void set(String val) {
        System.setProperty(this.topLevel(), val);
    }

    default public void set(String subDomain, String val) {
        System.setProperty(this.resolve(subDomain), val);
    }

    default public String topLevel() {
        return SysProp.getBaseDomain() + this.getPropertyKeyPath();
    }

    default public String resolve(String subDomain) {
        return SysProp.getBaseDomain() + "." + subDomain + this.getPropertyKeyPath();
    }

    default public String resolve(Path path) {
        return this.resolve(SysProp.formatPath(path));
    }

    default public Supplier<RuntimeException> getMandatoryExceptionSupplier() {
        return this.getMandatoryExceptionSupplier(null);
    }

    default public Supplier<RuntimeException> getMandatoryExceptionSupplier(String subDomain) {
        return () -> this.getMandatoryException(subDomain);
    }

    default public RuntimeException getMandatoryException(String subDomain) {
        return new IllegalStateException(String.format("'%s' must be provided.", subDomain == null ? this.topLevel() : this.resolve(subDomain)));
    }

    default public Optional<String> getStringProperty() {
        return this.getStringProperty(null);
    }

    default public Optional<String> getStringProperty(String subDomain) {
        return this.getStringProperty(subDomain, null);
    }

    default public Optional<String> getStringProperty(String subDomain, String defaultPropVal) {
        return Optional.ofNullable(System.getProperty(subDomain == null ? this.topLevel() : this.resolve(subDomain), defaultPropVal));
    }

    default public String getMandatoryStringProperty() {
        return this.getMandatoryStringProperty(null);
    }

    default public String getMandatoryStringProperty(String subDomain) {
        String val = System.getProperty(subDomain == null ? this.topLevel() : this.resolve(subDomain));
        if (val == null || val.isEmpty()) {
            throw this.getMandatoryException(subDomain);
        }
        return val;
    }

    default public OptionalInt getIntProperty() {
        return this.getIntProperty(null);
    }

    default public OptionalInt getIntProperty(String subDomain) {
        return this.getIntProperty(subDomain, null);
    }

    default public OptionalInt getIntProperty(String subDomain, String defaultPropVal) {
        return this.getStringProperty(subDomain, defaultPropVal).map(Integer::parseInt).map(OptionalInt::of).orElse(OptionalInt.empty());
    }

    default public int getMandatoryIntProperty() {
        return this.getMandatoryIntProperty(null);
    }

    default public int getMandatoryIntProperty(String subDomain) {
        return this.getStringProperty(subDomain).map(Integer::parseInt).orElseThrow(this.getMandatoryExceptionSupplier(subDomain));
    }

    default public OptionalLong getLongProperty() {
        return this.getLongProperty(null);
    }

    default public OptionalLong getLongProperty(String subDomain) {
        return this.getLongProperty(subDomain, null);
    }

    default public OptionalLong getLongProperty(String subDomain, String defaultPropVal) {
        return this.getStringProperty(subDomain, defaultPropVal).map(Long::parseLong).map(OptionalLong::of).orElse(OptionalLong.empty());
    }

    default public long getMandatoryLongProperty() {
        return this.getMandatoryLongProperty(null);
    }

    default public long getMandatoryLongProperty(String subDomain) {
        return this.getStringProperty(subDomain).map(Long::parseLong).orElseThrow(this.getMandatoryExceptionSupplier(subDomain));
    }

    default public OptionalDouble getDoubleProperty() {
        return this.getDoubleProperty(null);
    }

    default public OptionalDouble getDoubleProperty(String subDomain) {
        return this.getDoubleProperty(subDomain, null);
    }

    default public OptionalDouble getDoubleProperty(String subDomain, String defaultPropVal) {
        return this.getStringProperty(subDomain, defaultPropVal).map(Double::parseDouble).map(OptionalDouble::of).orElse(OptionalDouble.empty());
    }

    default public double getMandatoryDoubleProperty() {
        return this.getMandatoryDoubleProperty(null);
    }

    default public double getMandatoryDoubleProperty(String subDomain) {
        return this.getStringProperty(subDomain).map(Double::parseDouble).orElseThrow(this.getMandatoryExceptionSupplier(subDomain));
    }

    default public Optional<Boolean> getBooleanProperty() {
        return this.getBooleanProperty(null);
    }

    default public Optional<Boolean> getBooleanProperty(String subDomain) {
        return this.getBooleanProperty(subDomain, null);
    }

    default public Optional<Boolean> getBooleanProperty(String subDomain, String defaultPropVal) {
        return this.getStringProperty(subDomain, defaultPropVal).map(Boolean::parseBoolean);
    }

    default public boolean getMandatoryBooleanProperty() {
        return this.getMandatoryBooleanProperty(null);
    }

    default public boolean getMandatoryBooleanProperty(String subDomain) {
        return this.getStringProperty(subDomain).map(Boolean::parseBoolean).orElseThrow(this.getMandatoryExceptionSupplier(subDomain));
    }
}

