/*
 * Decompiled with CFR 0.152.
 */
package systems.comodal.jsonrpc;

import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Map;
import java.util.stream.IntStream;
import systems.comodal.jsonrpc.RpcEmptyBatchException;

public final class RpcRequestBodyFactory {
    static final char BATCHED_REQUEST_ID_DELIMETER = '-';
    private static final byte[] methodField = "{\"method\":\"".getBytes(StandardCharsets.US_ASCII);
    private static final byte[] version2_0Field = ",\"jsonrpc\":\"2.0\"".getBytes(StandardCharsets.US_ASCII);
    private static final byte[] idField = ",\"id\":\"".getBytes(StandardCharsets.US_ASCII);
    private static final byte[] paramsField = ",\"params\":[".getBytes(StandardCharsets.US_ASCII);
    private static final int fieldsLength = methodField.length + idField.length + paramsField.length + 6;
    private static final ThreadLocal<byte[]> requestBuffer = ThreadLocal.withInitial(() -> new byte[128]);
    private static final byte[] TRUE = "true".getBytes(StandardCharsets.US_ASCII);
    private static final byte[] FALSE = "false".getBytes(StandardCharsets.US_ASCII);

    private RpcRequestBodyFactory() {
    }

    public static byte[] createBatchRequest(byte[] method, byte[] id, Iterable<byte[][]> batch) {
        Iterator<byte[][]> iterator = batch.iterator();
        if (!iterator.hasNext()) {
            throw RpcEmptyBatchException.singleton;
        }
        byte[] buffer = requestBuffer.get();
        buffer[0] = 91;
        int minBufferLength = fieldsLength + method.length + id.length;
        int requestNum = 0;
        int offset = 1;
        while (true) {
            byte[][] params = iterator.next();
            boolean hasNext = iterator.hasNext();
            offset = RpcRequestBodyFactory.bufferRequest(buffer, minBufferLength, method, offset, requestNum, id, params, hasNext);
            buffer = requestBuffer.get();
            if (!hasNext) {
                return RpcRequestBodyFactory.closeBatch(buffer, offset);
            }
            ++requestNum;
        }
    }

    public static byte[] createBatchRequest(byte[] id, Map<byte[], byte[][]> batch) {
        Iterator<Map.Entry<byte[], byte[][]>> iterator = batch.entrySet().iterator();
        if (!iterator.hasNext()) {
            throw RpcEmptyBatchException.singleton;
        }
        byte[] buffer = requestBuffer.get();
        buffer[0] = 91;
        int minBufferLength = fieldsLength + id.length;
        int requestNum = 0;
        int offset = 1;
        while (true) {
            Map.Entry<byte[], byte[][]> request = iterator.next();
            byte[] method = request.getKey();
            boolean hasNext = iterator.hasNext();
            offset = RpcRequestBodyFactory.bufferRequest(buffer, minBufferLength + method.length, method, offset, requestNum, id, request.getValue(), hasNext);
            buffer = requestBuffer.get();
            if (!hasNext) {
                return RpcRequestBodyFactory.closeBatch(buffer, offset);
            }
            ++requestNum;
        }
    }

    private static byte[] createRequestIdPrefix(int requestNum) {
        return (Integer.toString(requestNum) + "-").getBytes(StandardCharsets.US_ASCII);
    }

    private static int bufferRequest(byte[] buffer, int minBufferLength, byte[] method, int offset, int requestNum, byte[] id, byte[][] params, boolean delimit) {
        byte[] idPrefix = RpcRequestBodyFactory.createRequestIdPrefix(requestNum);
        if (offset + minBufferLength + idPrefix.length > buffer.length) {
            buffer = RpcRequestBodyFactory.expand(buffer, offset, buffer.length << 1);
        }
        return RpcRequestBodyFactory.bufferRequest(buffer, offset, method, idPrefix, id, params, delimit);
    }

    private static byte[] closeBatch(byte[] buffer, int offset) {
        byte[] request = new byte[offset + 1];
        System.arraycopy(buffer, 0, request, 0, offset);
        request[offset] = 93;
        return request;
    }

    public static byte[] createRequest(byte[] method, byte[] id) {
        return RpcRequestBodyFactory.createRequest(method, id, new byte[0][]);
    }

    public static byte[] createRequest(byte[] method, byte[] id, byte[] param) {
        return RpcRequestBodyFactory.createRequest(id, method, new byte[][]{param});
    }

    public static byte[] createRequest(byte[] method, byte[] id, byte[][] params) {
        byte[] buffer = requestBuffer.get();
        if (fieldsLength + method.length + id.length > buffer.length) {
            buffer = RpcRequestBodyFactory.expand(buffer, 0, buffer.length << 1);
        }
        int offset = RpcRequestBodyFactory.bufferRequest(buffer, 0, method, id, params);
        return Arrays.copyOfRange(requestBuffer.get(), 0, offset);
    }

    private static int bufferRequest(byte[] buffer, int offset, byte[] method, byte[] idPrefix, byte[] id, byte[][] params, boolean delimit) {
        offset = RpcRequestBodyFactory.bufferMethod(buffer, offset, method);
        offset = RpcRequestBodyFactory.bufferId(buffer, offset, idPrefix, id);
        offset = RpcRequestBodyFactory.bufferParams(buffer, offset, params, delimit);
        return offset;
    }

    private static int bufferRequest(byte[] buffer, int offset, byte[] method, byte[] id, byte[][] params) {
        offset = RpcRequestBodyFactory.bufferMethod(buffer, offset, method);
        offset = RpcRequestBodyFactory.bufferId(buffer, offset, id);
        offset = RpcRequestBodyFactory.bufferParams(buffer, offset, params, false);
        return offset;
    }

    private static int bufferMethod(byte[] buffer, int offset, byte[] method) {
        System.arraycopy(methodField, 0, buffer, offset, methodField.length);
        System.arraycopy(method, 0, buffer, offset += methodField.length, method.length);
        offset += method.length;
        buffer[offset++] = 34;
        return offset;
    }

    private static int bufferVersion(byte[] buffer, int offset) {
        System.arraycopy(version2_0Field, 0, buffer, offset, version2_0Field.length);
        return offset + version2_0Field.length;
    }

    private static int bufferId(byte[] buffer, int offset, byte[] idPrefix, byte[] id) {
        if (id.length > 0) {
            System.arraycopy(idField, 0, buffer, offset, idField.length);
            System.arraycopy(idPrefix, 0, buffer, offset += idField.length, idPrefix.length);
            System.arraycopy(id, 0, buffer, offset += idPrefix.length, id.length);
            offset += id.length;
            buffer[offset++] = 34;
        }
        return offset;
    }

    private static int bufferId(byte[] buffer, int offset, byte[] id) {
        if (id.length > 0) {
            System.arraycopy(idField, 0, buffer, offset, idField.length);
            System.arraycopy(id, 0, buffer, offset += idField.length, id.length);
            offset += id.length;
            buffer[offset++] = 34;
        }
        return offset;
    }

    private static int bufferParams(byte[] buffer, int offset, byte[][] params, boolean delimit) {
        if (params.length > 0) {
            System.arraycopy(paramsField, 0, buffer, offset, paramsField.length);
            offset += paramsField.length;
            int last = params.length - 1;
            for (int i = 0; i < last; ++i) {
                byte[] param = params[i];
                if (offset + param.length >= buffer.length) {
                    int spaceNeeded = IntStream.range(i, params.length).map(j -> 1 + params[j].length).sum() + 4;
                    buffer = RpcRequestBodyFactory.expand(buffer, offset, offset + spaceNeeded);
                }
                System.arraycopy(param, 0, buffer, offset, param.length);
                offset += param.length;
                buffer[offset++] = 44;
            }
            byte[] param = params[last];
            System.arraycopy(param, 0, buffer, offset, param.length);
            offset += param.length;
            buffer[offset++] = 93;
        }
        buffer[offset++] = 125;
        if (delimit) {
            buffer[offset++] = 44;
        }
        return offset;
    }

    private static byte[] expand(byte[] buffer, int offset, int newLength) {
        byte[] expanded = new byte[newLength];
        System.arraycopy(buffer, 0, expanded, 0, offset);
        requestBuffer.set(expanded);
        return expanded;
    }

    public static byte[] createStringParam(String param) {
        return ("\"" + param + "\"").getBytes(StandardCharsets.US_ASCII);
    }

    public static byte[][] createStringParams(String param) {
        return new byte[][]{RpcRequestBodyFactory.createStringParam(param)};
    }

    public static byte[] createParam(String param) {
        return param.getBytes(StandardCharsets.US_ASCII);
    }

    public static byte[][] createParams(String param) {
        return new byte[][]{RpcRequestBodyFactory.createParam(param)};
    }

    public static byte[] createBoolParam(boolean bool) {
        return bool ? TRUE : FALSE;
    }
}

