/*
 * Decompiled with CFR 0.152.
 */
package systems.comodal.jsonrpc;

import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import systems.comodal.jsonrpc.ResultOverlay;
import systems.comodal.jsonrpc.ResultType;
import systems.comodal.jsonrpc.RpcException;
import systems.comodal.jsonrpc.RpcReplyParseException;

public final class RpcReplyBodyParser {
    private static final byte[] RESULT_FIELD = "result".getBytes(StandardCharsets.US_ASCII);
    private static final byte[] ERROR_FIELD = "error".getBytes(StandardCharsets.US_ASCII);
    private static final byte[] ERROR_CODE_FIELD = "code".getBytes(StandardCharsets.US_ASCII);
    private static final byte[] ERROR_MESSAGE_FIELD = "message".getBytes(StandardCharsets.US_ASCII);
    private static final byte[] ERROR_DATA_FIELD = "data".getBytes(StandardCharsets.US_ASCII);
    private static final byte[] ID_FIELD = "id".getBytes(StandardCharsets.US_ASCII);
    private static final byte[] VERSION_FIELD = "jsonrpc".getBytes(StandardCharsets.US_ASCII);
    private static final byte[] TRUE = "true".getBytes(StandardCharsets.US_ASCII);
    private static final byte[] FALSE = "false".getBytes(StandardCharsets.US_ASCII);
    private static final int NULL_OFFSET = 4;

    private RpcReplyBodyParser() {
    }

    public static ResultOverlay parseResult(byte[] body, byte[] expectedId) {
        ResultOverlay[] results = new ResultOverlay[1];
        RpcReplyBodyParser.parseResult(body, 0, expectedId, results);
        return results[0];
    }

    public static ResultOverlay[] parseResultBatch(byte[] body, byte[] expectedId, int numRequests) {
        ResultOverlay[] results = new ResultOverlay[numRequests];
        int offset = 0;
        while (body[offset++] != 91) {
            if (offset != body.length) continue;
            throw new RpcReplyParseException("Opening bracket for batch not found: " + new String(body));
        }
        for (int i = 0; i < numRequests; ++i) {
            offset = RpcReplyBodyParser.parseResult(body, offset, expectedId, results);
        }
        return results;
    }

    /*
     * Enabled aggressive block sorting
     */
    public static int parseResult(byte[] body, int offset, byte[] expectedId, ResultOverlay[] results) {
        ResultOverlay result = null;
        int resultIndex = -1;
        RpcException error = null;
        block18: while (true) {
            int j;
            block34: {
                int k;
                block33: {
                    byte bite;
                    if (offset >= body.length) {
                        throw new RpcReplyParseException("Unexpected end of response body: " + new String(body));
                    }
                    if ((bite = body[offset++]) == 125) {
                        if (error != null) {
                            throw error.setRequestId(new String(expectedId), resultIndex);
                        }
                        results[resultIndex] = result;
                        return offset + 2;
                    }
                    if (bite != 34) continue;
                    if (RpcReplyBodyParser.equalsField(body, offset, RESULT_FIELD)) {
                        offset = RpcReplyBodyParser.continueToVal(body, offset + RESULT_FIELD.length + 2);
                        switch (RpcReplyBodyParser.getValueType(body, offset)) {
                            case STRING: {
                                result = RpcReplyBodyParser.getStringOverlay(body, offset);
                                offset += result.getResultLength() + 1;
                                continue block18;
                            }
                            case NULL: {
                                offset += 4;
                                continue block18;
                            }
                            case NUMBER: {
                                result = RpcReplyBodyParser.getNumberOverlay(body, offset);
                                offset += result.getResultLength() + 1;
                                continue block18;
                            }
                            case ARRAY: {
                                int onePastSquare = RpcReplyBodyParser.skipObject(body, offset + 1, '[', ']');
                                result = new ResultOverlay(body, offset, onePastSquare - offset);
                                offset = onePastSquare;
                                continue block18;
                            }
                            case OBJECT: {
                                int onePastCurly = RpcReplyBodyParser.skipObject(body, offset + 1, '{', '}');
                                result = new ResultOverlay(body, offset, onePastCurly - offset);
                                offset = onePastCurly;
                                continue block18;
                            }
                        }
                        throw new RpcReplyParseException(String.format("Unsupported rpc result type '%s' at index %d in response body '%s'", new Object[]{RpcReplyBodyParser.getValueType(body, offset), offset, new String(body)}));
                    }
                    if (RpcReplyBodyParser.equalsField(body, offset, ERROR_FIELD)) {
                        offset = RpcReplyBodyParser.continueToVal(body, offset + ERROR_FIELD.length + 2);
                        switch (RpcReplyBodyParser.getValueType(body, offset)) {
                            case NULL: {
                                offset += 4;
                                continue block18;
                            }
                            case OBJECT: {
                                error = RpcReplyBodyParser.parseRpcError(body, offset);
                                offset = error.getOffset();
                                continue block18;
                            }
                        }
                        throw new RpcReplyParseException("Invalid response error format: " + new String(body));
                    }
                    if (RpcReplyBodyParser.equalsField(body, offset, ID_FIELD)) {
                        offset = RpcReplyBodyParser.continueToVal(body, offset + ID_FIELD.length + 2);
                        switch (RpcReplyBodyParser.getValueType(body, offset)) {
                            case STRING: {
                                j = ++offset;
                                while (true) {
                                    if (body[j] == 34) {
                                        if (results.length > 1) {
                                            k = offset + 1;
                                            break block33;
                                        }
                                        resultIndex = 0;
                                        break block34;
                                    }
                                    ++j;
                                }
                            }
                            case NULL: {
                                offset += 4;
                                continue block18;
                            }
                            default: {
                                throw new RpcReplyParseException("Invalid response id format: " + new String(body));
                            }
                        }
                    }
                    if (!RpcReplyBodyParser.equalsField(body, offset, VERSION_FIELD)) {
                        throw new RpcReplyParseException(String.format("Unknown response object field at index %d in response body '%s'.", offset, new String(body, offset, body.length - offset)));
                    }
                    offset = RpcReplyBodyParser.continueToVal(body, offset + VERSION_FIELD.length + 2);
                    switch (RpcReplyBodyParser.getValueType(body, offset)) {
                        case STRING: {
                            int n;
                            do {
                                n = ++offset;
                                ++offset;
                            } while (body[n] != 34);
                            continue block18;
                        }
                    }
                    throw new RpcReplyParseException("Invalid jsonrpc field value format: " + new String(body));
                }
                while (true) {
                    if (body[k] == 45) {
                        resultIndex = Integer.parseInt(new String(body, offset, k - offset));
                        offset = k + 1;
                        break;
                    }
                    ++k;
                }
            }
            if (!Arrays.equals(expectedId, 0, expectedId.length, body, offset, j)) {
                throw new RpcReplyParseException(String.format("Invalid request id, expected '%s', received '%s'.", new String(expectedId), new String(body, offset, j - offset)));
            }
            offset = j + 1;
        }
    }

    private static ResultOverlay getStringOverlay(byte[] body, int offset) {
        int j = offset + 1;
        while (j < body.length) {
            if (body[j++] != 34) continue;
            return new ResultOverlay(body, offset, j - offset);
        }
        throw new RpcReplyParseException("Unexpected end of response body: " + new String(body));
    }

    private static ResultOverlay getNumberOverlay(byte[] body, int offset) {
        for (int j = offset; j < body.length; ++j) {
            byte numByte = body[j];
            if (numByte != 44 && numByte != 32) continue;
            return new ResultOverlay(body, offset, j - offset);
        }
        throw new RpcReplyParseException("Unexpected end of response body: " + new String(body));
    }

    private static int skipObject(byte[] body, int offset, char open, char close) {
        int numOpen = 1;
        while (offset < body.length) {
            byte resultByte;
            if ((resultByte = body[offset++]) == close) {
                if (--numOpen != 0) continue;
                return offset;
            }
            if (resultByte != open) continue;
            ++numOpen;
        }
        throw new RpcReplyParseException("Unexpected end of response body: " + new String(body));
    }

    private static RpcException parseRpcError(byte[] body, int offset) {
        int code = 0;
        String msg = null;
        ResultOverlay data = null;
        block13: while (offset < body.length) {
            int j;
            byte bite;
            if ((bite = body[offset++]) == 125) {
                return RpcException.create(code, msg, data, offset);
            }
            if (bite != 34) continue;
            if (RpcReplyBodyParser.equalsField(body, offset, ERROR_CODE_FIELD)) {
                offset = RpcReplyBodyParser.continueToVal(body, offset + ERROR_CODE_FIELD.length + 2);
                switch (RpcReplyBodyParser.getValueType(body, offset)) {
                    case NUMBER: {
                        j = offset;
                        while (true) {
                            byte numByte;
                            if ((numByte = body[j]) == 44 || numByte == 32) {
                                code = Integer.parseInt(new String(body, offset, j - offset));
                                offset = j + 1;
                                continue block13;
                            }
                            ++j;
                        }
                    }
                }
                throw new RpcReplyParseException("Invalid error code field value format: " + new String(body));
            }
            if (RpcReplyBodyParser.equalsField(body, offset, ERROR_MESSAGE_FIELD)) {
                offset = RpcReplyBodyParser.continueToVal(body, offset + ERROR_MESSAGE_FIELD.length + 2);
                switch (RpcReplyBodyParser.getValueType(body, offset)) {
                    case STRING: {
                        j = ++offset;
                        while (true) {
                            if (body[j] == 34) {
                                msg = new String(body, offset, j - offset);
                                offset = j + 1;
                                continue block13;
                            }
                            ++j;
                        }
                    }
                    case NULL: {
                        offset += 4;
                        continue block13;
                    }
                }
                throw new RpcReplyParseException("Invalid error code message value format: " + new String(body));
            }
            if (RpcReplyBodyParser.equalsField(body, offset, ERROR_DATA_FIELD)) {
                offset = RpcReplyBodyParser.continueToVal(body, offset + RESULT_FIELD.length + 2);
                switch (RpcReplyBodyParser.getValueType(body, offset)) {
                    case STRING: {
                        data = RpcReplyBodyParser.getStringOverlay(body, offset);
                        offset += data.getResultLength() + 1;
                    }
                    case NUMBER: {
                        data = RpcReplyBodyParser.getNumberOverlay(body, offset);
                        offset += data.getResultLength() + 1;
                        continue block13;
                    }
                    case ARRAY: {
                        int onePastSquare = RpcReplyBodyParser.skipObject(body, offset + 1, '[', ']');
                        data = new ResultOverlay(body, offset, onePastSquare - offset);
                        offset = onePastSquare;
                        continue block13;
                    }
                    case OBJECT: {
                        int onePastCurly = RpcReplyBodyParser.skipObject(body, offset + 1, '{', '}');
                        data = new ResultOverlay(body, offset, onePastCurly - offset);
                        offset = onePastCurly;
                        continue block13;
                    }
                }
                throw new RpcReplyParseException(String.format("Unsupported rpc result type '%s' at index %d in response body '%s'", new Object[]{RpcReplyBodyParser.getValueType(body, offset), offset, new String(body)}));
            }
            throw new RpcReplyParseException(String.format("Unknown error object field at index %d in response body '%s'.", offset, new String(body, offset, body.length - offset)));
        }
        throw new RpcReplyParseException("Unexpected end while parsing error object: " + new String(body));
    }

    private static int continueToVal(byte[] body, int offset) {
        while (offset < body.length) {
            byte bite = body[offset];
            if (bite != 58 && bite != 32) {
                return offset;
            }
            ++offset;
        }
        throw new RpcReplyParseException("Invalid result body format: " + new String(body));
    }

    static ResultType getValueType(byte[] body, int offset) {
        byte typeByte = body[offset];
        switch (typeByte) {
            case 34: {
                return ResultType.STRING;
            }
            case 110: {
                return ResultType.NULL;
            }
            case 123: {
                return ResultType.OBJECT;
            }
            case 91: {
                return ResultType.ARRAY;
            }
            case 102: {
                if (Arrays.equals(FALSE, 0, FALSE.length, body, offset, FALSE.length)) {
                    return ResultType.FALSE;
                }
                throw new RpcReplyParseException(String.format("Invalid value type at index %d:%n '%s'.", offset, new String(body)));
            }
            case 116: {
                if (Arrays.equals(TRUE, 0, TRUE.length, body, offset, TRUE.length)) {
                    return ResultType.TRUE;
                }
                throw new RpcReplyParseException(String.format("Invalid value type at index %d:%n '%s'.", offset, new String(body)));
            }
        }
        if (Character.isDigit(typeByte) || typeByte == 45 || typeByte == 46) {
            return ResultType.NUMBER;
        }
        throw new RpcReplyParseException(String.format("Invalid value type at index %d:%n '%s'.", offset, new String(body)));
    }

    private static boolean equalsField(byte[] body, int offset, byte[] field) {
        for (byte bite : field) {
            if (body[offset++] == bite) continue;
            return false;
        }
        return true;
    }
}

