/*
 * Decompiled with CFR 0.152.
 */
package systems.comodal.jsonrpc;

import systems.comodal.jsonrpc.ResultOverlay;
import systems.comodal.jsonrpc.RpcInternalErrorException;
import systems.comodal.jsonrpc.RpcInvalidParamsException;
import systems.comodal.jsonrpc.RpcInvalidRequestException;
import systems.comodal.jsonrpc.RpcMethodNotFoundException;
import systems.comodal.jsonrpc.RpcParseException;
import systems.comodal.jsonrpc.RpcServerErrorException;

public class RpcException
extends RuntimeException {
    static final int PARSE_ERROR = -32700;
    static final int INVALID_REQUEST = -32600;
    static final int METHOD_NOT_FOUND = -32601;
    static final int INVALID_PARAMS = -32602;
    static final int INTERNAL_ERROR = -32603;
    static final int SERVER_ERROR_LOWER = -32099;
    static final int SERVER_ERROR_UPPER = -32000;
    private final int code;
    private final ResultOverlay data;
    private final int offset;
    private String id;
    private int requestIndex;

    RpcException(int code, String msg, ResultOverlay data, int offset) {
        super(msg);
        this.code = code;
        this.data = data;
        this.offset = offset;
    }

    static RpcException create(int code, String msg, ResultOverlay data, int offset) {
        switch (code) {
            case -32700: {
                return new RpcParseException(msg, data, offset);
            }
            case -32600: {
                return new RpcInvalidRequestException(msg, data, offset);
            }
            case -32601: {
                return new RpcMethodNotFoundException(msg, data, offset);
            }
            case -32602: {
                return new RpcInvalidParamsException(msg, data, offset);
            }
            case -32603: {
                return new RpcInternalErrorException(msg, data, offset);
            }
        }
        if (code >= -32099 && code <= -32000) {
            return new RpcServerErrorException(code, msg, data, offset);
        }
        return new RpcException(code, msg, data, offset);
    }

    RpcException setRequestId(String id, int requestIndex) {
        this.id = id;
        this.requestIndex = requestIndex;
        return this;
    }

    int getOffset() {
        return this.offset;
    }

    public final int getCode() {
        return this.code;
    }
}

