/*
 * Decompiled with CFR 0.152.
 */
package systems.comodal.jsonrpc;

import systems.comodal.jsonrpc.ResultType;
import systems.comodal.jsonrpc.RpcReplyBodyParser;

public final class ResultOverlay {
    private final byte[] response;
    private final int offset;
    private final int length;

    ResultOverlay(byte[] response, int offset, int length) {
        this.response = response;
        this.offset = offset;
        this.length = length;
    }

    public byte[] getResponse() {
        return this.response;
    }

    public int getResultOffset() {
        return this.offset;
    }

    public int getResultLength() {
        return this.length;
    }

    public byte[] extractStringBytes() {
        byte[] value = new byte[this.length - 2];
        System.arraycopy(this.response, this.offset + 1, value, 0, value.length);
        return value;
    }

    public String extractString() {
        return new String(this.response, this.offset + 1, this.length - 2);
    }

    public String asString() {
        return new String(this.response, this.offset, this.length);
    }

    public ResultType getResultType() {
        return RpcReplyBodyParser.getValueType(this.response, this.offset);
    }
}

