/*
 * Decompiled with CFR 0.152.
 */
package systems.comodal.guava.services;

import com.google.common.util.concurrent.ServiceManager;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.logging.Logger;
import systems.comodal.guava.services.ServiceGroupLoader;

public final class ServiceRunner {
    private ServiceRunner() {
    }

    public static void main(String[] args) {
        if (args.length == 0) {
            throw new IllegalStateException("No service group providers provided.");
        }
        ServiceRunner.awaitHealthy(ServiceRunner.createServiceGroups(args));
    }

    private static List<ServiceManager> createServiceGroups(String[] args) {
        ArrayList<ServiceManager> serviceGroups = new ArrayList<ServiceManager>(args.length);
        Arrays.stream(args).map(ServiceRunner::loadClass).map(ServiceRunner::createServiceManager).peek(ServiceManager::startAsync).forEach(serviceGroups::add);
        ServiceRunner.registerShutdownHook(serviceGroups);
        return serviceGroups;
    }

    private static void awaitHealthy(List<ServiceManager> serviceGroups) {
        Logger log = Logger.getLogger(ServiceRunner.class.getName());
        for (ServiceManager serviceGroup : serviceGroups) {
            serviceGroup.awaitHealthy();
            log.info(serviceGroup.startupTimes().toString());
        }
    }

    private static void registerShutdownHook(List<ServiceManager> serviceGroups) {
        Runtime.getRuntime().addShutdownHook(new Thread(() -> serviceGroups.forEach(ServiceManager::stopAsync)));
    }

    private static ServiceManager createServiceManager(Class<? extends ServiceGroupLoader> serviceLoaderClass) {
        try {
            ServiceGroupLoader serviceGroupLoader = serviceLoaderClass.newInstance();
            ServiceManager serviceManager = new ServiceManager(serviceGroupLoader.loadServices());
            serviceGroupLoader.addListeners(serviceManager);
            return serviceManager;
        }
        catch (ReflectiveOperationException e) {
            throw new IllegalStateException(serviceLoaderClass + " must have a public zero-argument constructor.");
        }
    }

    static Class<? extends ServiceGroupLoader> loadClass(String className) {
        try {
            Class<?> cls = Class.forName(className, true, ServiceRunner.class.getClassLoader());
            if (ServiceGroupLoader.class.isAssignableFrom(cls)) {
                return cls;
            }
            throw new IllegalStateException(String.format("Class '%s' does not implement ServiceGroupLoader.", className));
        }
        catch (ClassNotFoundException e) {
            throw new IllegalStateException("No class found for " + className);
        }
    }
}

