/*
 * Decompiled with CFR 0.152.
 */
package io.github.frizman21.common.sm;

import io.github.frizman21.common.sm.Activity;
import io.github.frizman21.common.sm.ConfigException;
import io.github.frizman21.common.sm.StateMachine;
import io.github.frizman21.common.sm.Transition;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import org.slf4j.Logger;

public class State {
    private Logger ConfigLogger = StateMachine.ConfigLogger;
    private Logger ExecLogger = StateMachine.ExecLogger;
    private String name;
    private boolean isEndState;
    private Map<String, Transition> transitionMap;
    List<Activity> activities;
    StateMachine machine;
    Properties props;

    State(String name, boolean isEndState, StateMachine machine) {
        this.name = name;
        this.isEndState = isEndState;
        this.machine = machine;
        this.activities = new ArrayList<Activity>();
        this.transitionMap = new HashMap<String, Transition>();
    }

    void init(Properties props) {
        this.props = props;
    }

    Transition get(String eventClassName) {
        return this.transitionMap.get(eventClassName);
    }

    public Transition addTransition(String transitionName, Class eventClass, State toState) {
        this.ConfigLogger.info("Adding transition (" + transitionName + ") from " + this.name + " to " + toState.name);
        String className = eventClass.getName();
        Transition transition = new Transition(transitionName, eventClass, this, toState, this.machine);
        transition.init(this.props);
        this.transitionMap.put(className, transition);
        return transition;
    }

    public boolean add(Activity activity) throws ConfigException {
        this.ConfigLogger.info("Adding activity (" + activity.getName() + ") to state (" + this.name + ")");
        activity.setStateMachine(this.machine);
        activity.init(this.props);
        return this.activities.add(activity);
    }

    public String getName() {
        return this.name;
    }

    public boolean isEndState() {
        return this.isEndState;
    }

    public int hashCode() {
        return Objects.hash(this.name);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        State other = (State)obj;
        return Objects.equals(this.name, other.name);
    }
}

