/*
 * Decompiled with CFR 0.152.
 */
package io.github.frizman21.common.sm;

import io.github.frizman21.common.sm.Activity;
import io.github.frizman21.common.sm.ConfigException;
import io.github.frizman21.common.sm.Event;
import io.github.frizman21.common.sm.State;
import io.github.frizman21.common.sm.StateMachineListener;
import io.github.frizman21.common.sm.Transition;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.LinkedBlockingQueue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StateMachine
implements Runnable {
    static Logger ConfigLogger = LoggerFactory.getLogger("friz.cs.StateMachine.Config");
    static Logger ExecLogger = LoggerFactory.getLogger("friz.cs.StateMachine.Execution");
    private long mainExecutionLoopSleepDuration = 10L;
    List<Event> registeredEvents;
    List<StateMachineListener> stateMachineListeners;
    List<State> states;
    State currentState;
    State startState;
    String name;
    Queue<Event> eventQueue;
    Map<String, Object> machineState;
    private boolean running;

    public StateMachine(String name) {
        this.name = name;
        this.states = new ArrayList<State>();
        this.stateMachineListeners = new ArrayList<StateMachineListener>();
        this.registeredEvents = new ArrayList<Event>();
        this.eventQueue = new LinkedBlockingQueue<Event>();
        this.machineState = new HashMap<String, Object>();
    }

    public boolean register(Event event) {
        return this.registeredEvents.add(event);
    }

    public boolean add(StateMachineListener listener) {
        return this.stateMachineListeners.add(listener);
    }

    public State createStartState(String name) throws ConfigException {
        if (this.startState == null) {
            State state;
            this.startState = state = this.createState(name);
            ConfigLogger.info("Declaring Start state (" + name + ")");
            return state;
        }
        String issueText = "State Machine already has a start state. Cannot have two start states.";
        ConfigLogger.warn(issueText);
        throw new ConfigException(issueText);
    }

    public State createState(String name) {
        return this.createState(name, false);
    }

    public State createState(String name, boolean isEndState) {
        ConfigLogger.info("Create state (" + name + ")");
        State state = new State(name, isEndState, this);
        this.states.add(state);
        return state;
    }

    public void startMachine(boolean startThread) throws ConfigException {
        if (startThread) {
            Thread thread = new Thread((Runnable)this, "State Machine Event Launch Loop");
            thread.start();
        } else {
            this.run();
        }
    }

    private void executeFirstTransition() throws ConfigException {
        if (this.startState == null) {
            String issueText = "Cannot start a stateMachine without an initial state.";
            ExecLogger.warn(issueText);
            throw new ConfigException(issueText);
        }
        ExecLogger.debug("Initializing state machine at state " + this.startState.getName());
        this.currentState = this.startState;
        for (StateMachineListener listener : this.stateMachineListeners) {
            try {
                listener.onEnterState(this.currentState);
            }
            catch (Exception e) {
                ExecLogger.warn(e.getMessage(), e);
            }
        }
        StateMachine.runActivities(this.currentState.activities);
    }

    public void eventHappens(Event event) throws ConfigException {
        ExecLogger.debug("Event " + event.getName() + " occured.");
        this.eventQueue.add(event);
    }

    private void executeEvent(Event event) throws ConfigException {
        String className = event.getClass().getName();
        Transition transition = this.currentState.get(className);
        if (transition == null) {
            String issueText = "Current state (" + this.currentState.getName() + ") does not have a transition for that event type. (" + event.getName() + ")";
            ConfigLogger.warn(issueText);
            throw new ConfigException(issueText);
        }
        for (StateMachineListener listener : this.stateMachineListeners) {
            try {
                listener.onExitState(transition.to);
            }
            catch (Exception e) {
                ExecLogger.warn(e.getMessage(), e);
            }
        }
        for (StateMachineListener listener : this.stateMachineListeners) {
            try {
                listener.onTransition(transition);
            }
            catch (Exception e) {
                ExecLogger.warn(e.getMessage(), e);
            }
        }
        StateMachine.runActivities(transition.activities);
        ExecLogger.debug("Transitioning from " + this.currentState.getName() + " to " + transition.to.getName() + " on " + event.getName());
        this.currentState = transition.to;
        for (StateMachineListener listener : this.stateMachineListeners) {
            try {
                listener.onEnterState(transition.to);
            }
            catch (Exception e) {
                ExecLogger.warn(e.getMessage(), e);
            }
        }
        StateMachine.runActivities(this.currentState.activities);
        if (this.currentState.isEndState()) {
            this.running = false;
            ExecLogger.debug("running is now false. thread should end soon.");
        }
    }

    private static void runActivities(List<Activity> activities) {
        for (Activity activity : activities) {
            try {
                ExecLogger.debug("Activity (" + activity.getName() + ") being run.");
                activity.run();
            }
            catch (Exception ex) {
                ExecLogger.warn("Activity " + activity.getName() + " threw an Exception.", ex);
                ex.printStackTrace();
            }
        }
    }

    @Override
    public void run() {
        this.running = true;
        try {
            this.executeFirstTransition();
        }
        catch (ConfigException e) {
            ConfigLogger.warn("startMachine() failed to run");
            return;
        }
        while (this.running) {
            if (this.eventQueue.size() > 0) {
                Event event = this.eventQueue.poll();
                try {
                    this.executeEvent(event);
                }
                catch (ConfigException e) {
                    ExecLogger.warn("Event execution failed: ", e);
                }
                continue;
            }
            try {
                Thread.sleep(this.mainExecutionLoopSleepDuration);
            }
            catch (InterruptedException e) {
                ConfigLogger.warn("Main Execution Loop Sleep Excepted", e);
            }
        }
    }

    public void kill() {
        this.running = false;
    }

    public boolean isMachineRunning() {
        return this.running;
    }

    public boolean waitUntilDone(long timeout) {
        long startTime = Calendar.getInstance().getTimeInMillis();
        while (startTime + timeout > Calendar.getInstance().getTimeInMillis()) {
            if (!this.running) {
                ExecLogger.debug("Running flag off. waitUntilDone succeeds.");
                return true;
            }
            try {
                Thread.sleep(this.mainExecutionLoopSleepDuration);
            }
            catch (InterruptedException e) {
                ConfigLogger.warn("sleep failed while WaitingUtilDone", e);
                return false;
            }
        }
        ExecLogger.debug("Timeout reached, waitUntilDone failed.");
        return false;
    }

    public State getState() {
        return this.currentState;
    }

    public Object getFromMachineState(Object key) {
        return this.machineState.get(key);
    }

    public Object putFromMachineState(String key, Object value) {
        return this.machineState.put(key, value);
    }
}

