/*
 * Decompiled with CFR 0.152.
 */
package systems.aesel.common.sm.util;

import java.io.IOException;
import java.util.Calendar;
import org.apache.log4j.Logger;
import systems.aesel.common.sm.Activity;
import systems.aesel.common.sm.StateMachine;

public class LaunchProcessActivity
implements Activity {
    static Logger ConfigLogger = Logger.getLogger((String)"ConfigLogger");
    static Logger IntLogger = Logger.getLogger((String)"IntegrationLogger");
    protected static final String FileNameTemplate = "PREFIX-DATE-TIME.EXTEN";
    public static final String Prop_PreviousLaunchedProcess = "PreviousLaunchedProcess";
    public static final String Prop_LaunchedProcess = "LaunchedProcess";
    protected String commandLine;
    protected String outputFilePrefix;
    protected String extension;
    protected String filename;
    protected long duration;
    protected StateMachine machine;
    protected Process process;

    public LaunchProcessActivity(String commandLine, String outputFilePrefix, String extension, long duration) {
        this.commandLine = commandLine;
        this.outputFilePrefix = outputFilePrefix;
        this.extension = extension;
        this.duration = duration;
    }

    public Process getProcess() {
        return this.process;
    }

    private static String twoDigit(long value) {
        String returnValue = "" + value;
        if (returnValue.length() == 1) {
            returnValue = "0" + returnValue;
        }
        return returnValue;
    }

    @Override
    public void run() {
        IntLogger.debug((Object)"LaunchProcessActivity.run()");
        Runtime rt = Runtime.getRuntime();
        Calendar cal = Calendar.getInstance();
        String cmdToExec = this.commandLine.replaceFirst("PREFIX", this.outputFilePrefix);
        cmdToExec = cmdToExec.replaceFirst("DATE", this.getDateString(cal));
        cmdToExec = cmdToExec.replaceFirst("TIME", this.getTimeString(cal));
        cmdToExec = cmdToExec.replaceFirst("EXTEN", this.extension);
        long timeToLive = this.duration;
        long hours = timeToLive / 3600L;
        long mins = (timeToLive -= hours * 3600L) / 60L;
        long secs = timeToLive -= mins * 60L;
        cmdToExec = cmdToExec.replaceFirst("DURATION", LaunchProcessActivity.twoDigit(hours) + ":" + LaunchProcessActivity.twoDigit(mins) + ":" + LaunchProcessActivity.twoDigit(secs));
        String filename = FileNameTemplate.replaceFirst("PREFIX", this.outputFilePrefix);
        filename = filename.replaceFirst("DATE", this.getDateString(cal));
        filename = filename.replaceFirst("TIME", this.getTimeString(cal));
        this.filename = filename = filename.replaceFirst("EXTEN", this.extension);
        IntLogger.debug((Object)("New Process output filename: " + this.filename));
        IntLogger.debug((Object)("executing " + cmdToExec));
        try {
            Object previousObj = this.machine.getFromMachineState(Prop_LaunchedProcess);
            if (previousObj != null) {
                this.machine.putFromMachineState(Prop_PreviousLaunchedProcess, (Process)previousObj);
            }
            this.process = rt.exec(cmdToExec);
            this.machine.putFromMachineState(Prop_LaunchedProcess, this.process);
        }
        catch (IOException e) {
            IntLogger.warn((Object)"Process launch threw an exception. Review command for dependencies and gaps.", (Throwable)e);
            e.printStackTrace();
        }
    }

    public String getFilename() {
        return this.filename;
    }

    protected String getDateString(Calendar cal) {
        return "" + cal.get(1) + this.forceLength(cal.get(2) + 1, 2) + this.forceLength(cal.get(5), 2);
    }

    protected String getTimeString(Calendar cal) {
        return "" + this.forceLength(cal.get(11), 2) + this.forceLength(cal.get(12), 2) + this.forceLength(cal.get(13), 2);
    }

    private String forceLength(int value, int size) {
        String valueStr = "" + value;
        while (valueStr.length() < size) {
            valueStr = "0" + valueStr;
        }
        return valueStr;
    }

    @Override
    public String getName() {
        return "Launch ffmpeg";
    }

    @Override
    public void setStateMachine(StateMachine machine) {
        this.machine = machine;
    }
}

