/*
 * Decompiled with CFR 0.152.
 */
package systems.aesel.common.sm.util;

import java.io.FileOutputStream;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;
import org.apache.log4j.Logger;
import systems.aesel.common.sm.Activity;
import systems.aesel.common.sm.StateMachine;

public class DownloadHttpFileActivity
implements Activity {
    static Logger ConfigLogger = Logger.getLogger((String)"friz.video.nvr.Config");
    static Logger IntLogger = Logger.getLogger((String)"friz.video.nvr.Integration");
    static Logger swLogger = Logger.getLogger(DownloadHttpFileActivity.class);
    private String filename;
    private String urlToDownload;

    public DownloadHttpFileActivity(String filename, String urlToDownload) {
        this.filename = filename;
        this.urlToDownload = urlToDownload;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            if (this.urlToDownload == null || this.urlToDownload.isEmpty()) {
                ConfigLogger.warn((Object)"URL is not provided.");
                return;
            }
            if (this.filename == null || this.filename.isEmpty()) {
                ConfigLogger.warn((Object)"HTTP image download filename is not provided. (FTPDestinationFileName)");
                return;
            }
            URL website = new URL(this.urlToDownload);
            ReadableByteChannel rbc = Channels.newChannel(website.openStream());
            FileOutputStream fos = new FileOutputStream(this.filename);
            fos.getChannel().transferFrom(rbc, 0L, Long.MAX_VALUE);
            fos.close();
        }
        catch (MalformedURLException e) {
            ConfigLogger.warn((Object)"URL is not correct.", (Throwable)e);
            throw new RuntimeException(e);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    public String getName() {
        return "DownloadHttpFileActivity";
    }

    @Override
    public void setStateMachine(StateMachine machine) {
    }
}

