/*
 * Decompiled with CFR 0.152.
 */
package systems.aesel.common.sm;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.LinkedBlockingQueue;
import org.apache.log4j.Logger;
import systems.aesel.common.sm.Activity;
import systems.aesel.common.sm.ConfigException;
import systems.aesel.common.sm.Event;
import systems.aesel.common.sm.State;
import systems.aesel.common.sm.StateMachineListener;
import systems.aesel.common.sm.Transition;

public class StateMachine
implements Runnable {
    static Logger ConfigLogger = Logger.getLogger((String)"friz.cs.StateMachine.Config");
    static Logger ExecLogger = Logger.getLogger((String)"friz.cs.StateMachine.Execution");
    private long mainExecutionLoopSleepDuration = 10L;
    List<Event> registeredEvents;
    List<StateMachineListener> stateMachineListeners;
    List<State> states;
    State currentState;
    State startState;
    String name;
    Queue<Event> eventQueue;
    Map<String, Object> machineState;
    private boolean running;

    public StateMachine(String name) {
        this.name = name;
        this.states = new ArrayList<State>();
        this.stateMachineListeners = new ArrayList<StateMachineListener>();
        this.registeredEvents = new ArrayList<Event>();
        this.eventQueue = new LinkedBlockingQueue<Event>();
        this.machineState = new HashMap<String, Object>();
    }

    public boolean register(Event event) {
        return this.registeredEvents.add(event);
    }

    public boolean add(StateMachineListener listener) {
        return this.stateMachineListeners.add(listener);
    }

    public State createStartState(String name) throws ConfigException {
        if (this.startState == null) {
            State state;
            this.startState = state = this.createState(name);
            ConfigLogger.info((Object)("Declaring Start state (" + name + ")"));
            return state;
        }
        String issueText = "State Machine already has a start state. Cannot have two start states.";
        ConfigLogger.warn((Object)issueText);
        throw new ConfigException(issueText);
    }

    public State createState(String name) {
        return this.createState(name, false);
    }

    public State createState(String name, boolean isEndState) {
        ConfigLogger.info((Object)("Create state (" + name + ")"));
        State state = new State(name, isEndState, this);
        this.states.add(state);
        return state;
    }

    public void startMachine(boolean startThread) throws ConfigException {
        if (startThread) {
            Thread thread = new Thread((Runnable)this, "State Machine Event Launch Loop");
            thread.start();
        } else {
            this.run();
        }
    }

    private void executeFirstTransition() throws ConfigException {
        if (this.startState == null) {
            String issueText = "Cannot start a stateMachine without an initial state.";
            ExecLogger.warn((Object)issueText);
            throw new ConfigException(issueText);
        }
        ExecLogger.debug((Object)("Initializing state machine at state " + this.startState.getName()));
        this.currentState = this.startState;
        for (StateMachineListener listener : this.stateMachineListeners) {
            try {
                listener.onEnterState(this.currentState);
            }
            catch (Exception e) {
                ExecLogger.warn((Object)e);
            }
        }
        StateMachine.runActivities(this.currentState.activities);
    }

    public void eventHappens(Event event) throws ConfigException {
        ExecLogger.debug((Object)("Event " + event.getName() + " occured."));
        this.eventQueue.add(event);
    }

    private void executeEvent(Event event) throws ConfigException {
        String className = event.getClass().getName();
        Transition transition = this.currentState.get(className);
        if (transition == null) {
            String issueText = "Current state (" + this.currentState.getName() + ") does not have a " + "transition for that event type. (" + event.getName() + ")";
            ConfigLogger.warn((Object)issueText);
            throw new ConfigException(issueText);
        }
        for (StateMachineListener listener : this.stateMachineListeners) {
            try {
                listener.onExitState(transition.to);
            }
            catch (Exception e) {
                ExecLogger.warn((Object)e);
            }
        }
        for (StateMachineListener listener : this.stateMachineListeners) {
            try {
                listener.onTransition(transition);
            }
            catch (Exception e) {
                ExecLogger.warn((Object)e);
            }
        }
        StateMachine.runActivities(transition.activities);
        ExecLogger.debug((Object)("Transitioning from " + this.currentState.getName() + " to " + transition.to.getName() + " on " + event.getName()));
        this.currentState = transition.to;
        for (StateMachineListener listener : this.stateMachineListeners) {
            try {
                listener.onEnterState(transition.to);
            }
            catch (Exception e) {
                ExecLogger.warn((Object)e);
            }
        }
        StateMachine.runActivities(this.currentState.activities);
        if (this.currentState.isEndState()) {
            this.running = false;
            ExecLogger.debug((Object)"running is now false. thread should end soon.");
        }
    }

    private static void runActivities(List<Activity> activities) {
        for (Activity activity : activities) {
            try {
                ExecLogger.debug((Object)("Activity (" + activity.getName() + ") being run."));
                activity.run();
            }
            catch (Exception ex) {
                ExecLogger.warn((Object)("Activity " + activity.getName() + " threw an Exception."), (Throwable)ex);
                ex.printStackTrace();
            }
        }
    }

    @Override
    public void run() {
        this.running = true;
        try {
            this.executeFirstTransition();
        }
        catch (ConfigException e) {
            ConfigLogger.warn((Object)"startMachine() failed to run");
            return;
        }
        while (this.running) {
            if (this.eventQueue.size() > 0) {
                Event event = this.eventQueue.poll();
                try {
                    this.executeEvent(event);
                }
                catch (ConfigException e) {
                    ExecLogger.warn((Object)"Event execution failed: ", (Throwable)e);
                }
                continue;
            }
            try {
                Thread.sleep(this.mainExecutionLoopSleepDuration);
            }
            catch (InterruptedException e) {
                ConfigLogger.warn((Object)"Main Execution Loop Sleep Excepted", (Throwable)e);
            }
        }
    }

    public void kill() {
        this.running = false;
    }

    public boolean isMachineRunning() {
        return this.running;
    }

    public boolean waitUntilDone(long timeout) {
        long startTime = Calendar.getInstance().getTimeInMillis();
        while (startTime + timeout > Calendar.getInstance().getTimeInMillis()) {
            if (!this.running) {
                ExecLogger.debug((Object)"Running flag off. waitUntilDone succeeds.");
                return true;
            }
            try {
                Thread.sleep(this.mainExecutionLoopSleepDuration);
            }
            catch (InterruptedException e) {
                ConfigLogger.warn((Object)"sleep failed while WaitingUtilDone", (Throwable)e);
                return false;
            }
        }
        ExecLogger.debug((Object)"Timeout reached, waitUntilDone failed.");
        return false;
    }

    public State getState() {
        return this.currentState;
    }

    public Object getFromMachineState(Object key) {
        return this.machineState.get(key);
    }

    public Object putFromMachineState(String key, Object value) {
        return this.machineState.put(key, value);
    }
}

