/*
 * Decompiled with CFR 0.152.
 */
package systems.aesel.common.sm;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import systems.aesel.common.sm.Activity;
import systems.aesel.common.sm.StateMachine;
import systems.aesel.common.sm.Transition;

public class State {
    private Logger ConfigLogger = StateMachine.ConfigLogger;
    private Logger ExecLogger = StateMachine.ExecLogger;
    private String name;
    private boolean isEndState;
    private Map<String, Transition> transitionMap;
    List<Activity> activities;
    StateMachine machine;

    State(String name, boolean isEndState, StateMachine machine) {
        this.name = name;
        this.isEndState = isEndState;
        this.machine = machine;
        this.activities = new ArrayList<Activity>();
        this.transitionMap = new HashMap<String, Transition>();
    }

    Transition get(String eventClassName) {
        return this.transitionMap.get(eventClassName);
    }

    public Transition addTransition(String transitionName, Class eventClass, State toState) {
        this.ConfigLogger.info((Object)("Adding transition (" + transitionName + ") from " + this.name + " to " + toState.name));
        String className = eventClass.getName();
        Transition transition = new Transition(transitionName, eventClass, this, toState, this.machine);
        this.transitionMap.put(className, transition);
        return transition;
    }

    public boolean add(Activity activity) {
        this.ConfigLogger.info((Object)("Adding activity (" + activity.getName() + ") to state (" + this.name + ")"));
        activity.setStateMachine(this.machine);
        return this.activities.add(activity);
    }

    public String getName() {
        return this.name;
    }

    public boolean isEndState() {
        return this.isEndState;
    }
}

