/*
 * Decompiled with CFR 0.152.
 */
package synapticloop.documentr.parser;

import java.io.File;
import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.io.FileUtils;
import synapticloop.documentr.bean.DependencyGroup;
import synapticloop.templar.utils.TemplarContext;
import synapticloop.util.SimpleLogger;

public class GradleParser {
    private static final SimpleLogger LOGGER = SimpleLogger.getLoggerSimpleName(GradleParser.class);

    public GradleParser(TemplarContext templarContext, File file) {
        if (file.exists() && file.canRead() && file.isFile()) {
            try {
                List readLines = FileUtils.readLines((File)file);
                Iterator<String> iterator = readLines.iterator();
                while (iterator.hasNext()) {
                    String line = ((String)iterator.next()).trim();
                    if (line.startsWith("group")) {
                        this.addToContext(templarContext, "group", line);
                        continue;
                    }
                    if (line.startsWith("version")) {
                        this.addToContext(templarContext, "version", line);
                        continue;
                    }
                    if (line.startsWith("description")) {
                        this.addToContext(templarContext, "description", line);
                        continue;
                    }
                    if (line.startsWith("archivesBaseName")) {
                        this.addToContext(templarContext, "project", line);
                        continue;
                    }
                    if (!line.startsWith("dependencies")) continue;
                    this.addToContext(templarContext, iterator, "dependencyGroup");
                }
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
        }
    }

    private void addToContext(TemplarContext templarContext, Iterator<String> iterator, String key) {
        DependencyGroup dependencyGroup = new DependencyGroup();
        while (iterator.hasNext()) {
            String dependency;
            String line = iterator.next().trim();
            if (line.startsWith("}")) {
                templarContext.add("dependencyGroup", (Object)dependencyGroup);
                return;
            }
            if (line.startsWith("runtime")) {
                dependency = line.split(" ")[1];
                dependencyGroup.addDependency("runtime", dependency);
                LOGGER.info(String.format("Found 'runtime' dependency of '%s'", dependency));
                continue;
            }
            if (!line.startsWith("compile")) continue;
            dependency = line.split(" ")[1];
            dependencyGroup.addDependency("compile", dependency);
            LOGGER.info(String.format("Found 'compile' dependency of '%s'", dependency));
        }
    }

    private void addToContext(TemplarContext templarContext, String key, String line) {
        LOGGER.info(String.format("Looking for key '%s' in line '%s'", key, line));
        String[] split = line.trim().split("=", 2);
        if (split.length != 2) {
            LOGGER.info(String.format("Could not find splittable '=' for key '%s' in line '%s', ignoring...", key, line));
            return;
        }
        String value = split[1].trim().replaceAll("\"", "").replaceAll("'", "");
        templarContext.add(key, (Object)value);
        LOGGER.info(String.format("Added '%s':'%s' to context", key, value));
    }
}

