/*
 * Decompiled with CFR 0.152.
 */
package synapticloop.documentr;

import java.io.File;
import java.io.IOException;
import java.util.Calendar;
import java.util.Iterator;
import org.apache.commons.io.FileUtils;
import org.json.JSONArray;
import org.json.JSONObject;
import synapticloop.documentr.parser.GradleParser;
import synapticloop.templar.Parser;
import synapticloop.templar.exception.ParseException;
import synapticloop.templar.exception.RenderException;
import synapticloop.templar.utils.TemplarContext;
import synapticloop.util.SimpleUsage;

public class Main {
    private static final String VALUE = "value";
    private static final String TYPE = "type";

    private static void overrideContext(TemplarContext templarContext, JSONObject jsonObject) {
        JSONObject contextObject = jsonObject.getJSONObject("context");
        Iterator keys = contextObject.keys();
        while (keys.hasNext()) {
            String key = (String)keys.next();
            templarContext.add(key, contextObject.get(key));
        }
    }

    public static void main(String[] args) {
        String option;
        if (args.length != 1) {
            SimpleUsage.usageAndExit(null);
        }
        if ("--help".equals(option = args[0])) {
            SimpleUsage.usageAndExit(null);
        }
        System.out.println(args[0]);
        File file = new File(option + "/documentr.json");
        if (file.exists() && file.canRead()) {
            try {
                StringBuilder stringBuilder = new StringBuilder();
                JSONObject jsonObject = new JSONObject(FileUtils.readFileToString((File)file));
                JSONArray jsonArray = jsonObject.getJSONArray("templates");
                for (Object object : jsonArray) {
                    JSONObject templateObject = (JSONObject)object;
                    if ("inbuilt".equals(templateObject.getString(TYPE))) {
                        stringBuilder.append("{import classpath:/");
                        stringBuilder.append(templateObject.getString(VALUE));
                        stringBuilder.append(".templar}\n");
                        continue;
                    }
                    if ("file".equals(templateObject.getString(TYPE))) {
                        stringBuilder.append("{pre\n");
                        stringBuilder.append(FileUtils.readFileToString((File)new File(file.getParent() + "/" + templateObject.getString(VALUE))));
                        stringBuilder.append("\npre}\n");
                        continue;
                    }
                    if ("markup".equals(templateObject.getString(TYPE))) {
                        stringBuilder.append("\n");
                        stringBuilder.append(templateObject.getString(VALUE).replaceAll("\\{", "\\{\\{").replaceAll("\\n", "\\{\\\\n\\}").replaceAll("\\t", "\\{\\\\t\\}"));
                        stringBuilder.append("\n");
                        continue;
                    }
                    if (!"template".equals(templateObject.getString(TYPE))) continue;
                    stringBuilder.append("\n");
                    stringBuilder.append("{import ");
                    stringBuilder.append(file.getParent() + "/" + templateObject.getString(VALUE));
                    stringBuilder.append("}\n");
                    stringBuilder.append("\n");
                }
                TemplarContext templarContext = new TemplarContext();
                templarContext.add("yearTo", (Object)Calendar.getInstance().get(1));
                File gradleBuildFile = new File(file.getParent() + "/build.gradle");
                new GradleParser(templarContext, gradleBuildFile);
                Main.overrideContext(templarContext, jsonObject);
                Parser parser = new Parser(stringBuilder.toString());
                FileUtils.writeStringToFile((File)new File(file.getParent() + "/README.md"), (String)parser.render(templarContext));
            }
            catch (IOException | ParseException | RenderException ex) {
                SimpleUsage.usageAndExit((String)("Cannot parse/render the documentr.json file, message was: " + ex.getMessage()));
            }
        } else {
            SimpleUsage.usageAndExit((String)"Cannot find the documentr.json file.");
        }
    }
}

